"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTarget = void 0;
const child_process_1 = require("./child-process");
async function getTarget() {
    try {
        const remote = await child_process_1.spawn('git', ['remote', 'get-url', 'origin']);
        const revParse = await child_process_1.spawn('git', ['rev-parse', '--abbrev-ref', 'HEAD']);
        return {
            remoteUrl: remote.stdout.trim(),
            branch: revParse.stdout.trim(),
        };
    }
    catch (err) {
        // when git is not installed
        return {
            remoteUrl: '',
            branch: '',
        };
    }
}
exports.getTarget = getTarget;
//# sourceMappingURL=git.js.map