"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClassPathFromGradle = exports.getGradleCommandArgs = void 0;
const tslib_1 = require("tslib");
require("source-map-support/register");
const sub_process_1 = require("./sub-process");
const path = require("path");
const errors_1 = require("./errors");
const os_1 = require("os");
function getGradleCommandArgs(targetPath, initScript) {
    const gradleArgs = [
        'printClasspath',
        '-I',
        path.join(__dirname, ...'../bin/init.gradle'.split('/')),
        '-q',
    ];
    if (targetPath) {
        gradleArgs.push('-p', targetPath);
    }
    if (initScript) {
        gradleArgs.push('--init-script', initScript);
    }
    return gradleArgs;
}
exports.getGradleCommandArgs = getGradleCommandArgs;
function getClassPathFromGradle(targetPath, gradlePath, initScript) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const args = getGradleCommandArgs(targetPath, initScript);
        try {
            const output = yield sub_process_1.execute(gradlePath, args, { cwd: targetPath });
            const lines = output.trim().split(os_1.EOL);
            const lastLine = lines[lines.length - 1];
            return lastLine.trim();
        }
        catch (e) {
            console.log(e);
            throw new errors_1.ClassPathGenerationError(e);
        }
    });
}
exports.getClassPathFromGradle = getClassPathFromGradle;
//# sourceMappingURL=gradle-wrapper.js.map