import "core-js/modules/es.promise.js";
import { loadManagerOrAddonsFile } from '@storybook/core-common';
import createDevConfig from '../manager/manager-webpack.config';
export async function managerWebpack(_, options) {
  return createDevConfig(options);
}
export async function managerEntries(installedAddons, options) {
  var _options$managerEntry = options.managerEntry,
      managerEntry = _options$managerEntry === void 0 ? '@storybook/core-client/dist/esm/manager' : _options$managerEntry;
  var entries = [require.resolve('../globals/polyfills')];

  if (installedAddons && installedAddons.length) {
    entries.push(...installedAddons);
  }

  var managerConfig = loadManagerOrAddonsFile(options);

  if (managerConfig) {
    entries.push(managerConfig);
  }

  entries.push(require.resolve(managerEntry));
  return entries;
}