"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.webpack = webpack;

var _nodeLogger = require("@storybook/node-logger");

var _coreCommon = require("@storybook/core-common");

var _baseWebpack = require("../preview/base-webpack.config");

async function webpack(config, options) {
  var configDir = options.configDir,
      configType = options.configType,
      presets = options.presets,
      webpackConfig = options.webpackConfig;
  var defaultConfig = await (0, _baseWebpack.createDefaultWebpackConfig)(config, options);
  var finalDefaultConfig = await presets.apply('webpackFinal', defaultConfig, options); // through standalone webpackConfig option

  if (webpackConfig) {
    return webpackConfig(finalDefaultConfig);
  } // Check whether user has a custom webpack config file and
  // return the (extended) base configuration if it's not available.


  var customConfig = (0, _coreCommon.loadCustomWebpackConfig)(configDir);

  if (typeof customConfig === 'function') {
    _nodeLogger.logger.info('=> Loading custom Webpack config (full-control mode).');

    return customConfig({
      config: finalDefaultConfig,
      mode: configType
    });
  }

  _nodeLogger.logger.info('=> Using default Webpack4 setup');

  return finalDefaultConfig;
}