"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseProps = exports.getDomain = exports.getData = exports.getFormattedData = void 0;

var _isNil2 = _interopRequireDefault(require("lodash/isNil"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

var _victoryBar = require("victory-bar");

var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));

var d3Array = _interopRequireWildcard(require("d3-array"));

var d3Scale = _interopRequireWildcard(require("d3-scale"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

var cacheLastValue = function (func) {
  var called = false;
  var lastArgs;
  var lastReturnVal;
  return function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    if (called && (0, _reactFastCompare.default)(lastArgs, args)) {
      return lastReturnVal;
    }

    var value = func.apply(void 0, args);
    called = true;
    lastReturnVal = value;
    lastArgs = args;
    return value;
  };
};

var dataOrBinsContainDates = function (_ref) {
  var data = _ref.data,
      bins = _ref.bins,
      x = _ref.x;

  var xAccessor = _victoryCore.Helpers.createAccessor(x || "x");

  var dataIsDates = data.some(function (datum) {
    return xAccessor(datum) instanceof Date;
  });
  var binsHasDates = Array.isArray(bins) && bins.some(function (bin) {
    return bin instanceof Date;
  });
  return dataIsDates || binsHasDates;
};

var getBinningFunc = function (_ref2) {
  var data = _ref2.data,
      x = _ref2.x,
      bins = _ref2.bins,
      dataOrBinsContainsDates = _ref2.dataOrBinsContainsDates;

  var xAccessor = _victoryCore.Helpers.createAccessor(x || "x");

  var bin = d3Array.bin().value(xAccessor);
  var niceScale = (dataOrBinsContainsDates ? d3Scale.scaleTime() : d3Scale.scaleLinear()).domain(d3Array.extent(data, xAccessor)).nice();

  if (Array.isArray(bins)) {
    bin.domain([bins[0], bins[bins.length - 1]]);
    bin.thresholds(bins);
    return bin;
  }

  if (Number.isInteger(bins)) {
    bin.domain(niceScale.domain());
    bin.thresholds(bins);
    return bin;
  }

  if (dataOrBinsContainsDates) {
    bin.domain(niceScale.domain());
    bin.thresholds(niceScale.ticks());
    return bin;
  }

  bin.domain(niceScale.domain());
  return bin;
};

var getFormattedData = cacheLastValue(function (_ref3) {
  var _ref3$data = _ref3.data,
      data = _ref3$data === void 0 ? [] : _ref3$data,
      x = _ref3.x,
      bins = _ref3.bins;

  if ((!data || !data.length) && !Array.isArray(bins)) {
    return [];
  }

  var dataOrBinsContainsDates = dataOrBinsContainDates({
    data: data,
    bins: bins,
    x: x
  });
  var binFunc = getBinningFunc({
    data: data,
    x: x,
    bins: bins,
    dataOrBinsContainsDates: dataOrBinsContainsDates
  });
  var foo = binFunc(data);
  var binnedData = foo.filter(function (_ref4) {
    var x0 = _ref4.x0,
        x1 = _ref4.x1;

    if (dataOrBinsContainsDates) {
      return new Date(x0).getTime() !== new Date(x1).getTime();
    }

    return x0 !== x1;
  });
  var formattedData = binnedData.map(function (bin) {
    var x0 = dataOrBinsContainsDates ? new Date(bin.x0) : bin.x0;
    var x1 = dataOrBinsContainsDates ? new Date(bin.x1) : bin.x1;
    return {
      x0: x0,
      x1: x1,
      x: dataOrBinsContainsDates ? new Date((x0.getTime() + x1.getTime()) / 2) : (x0 + x1) / 2,
      y: bin.length,
      binnedData: _toConsumableArray(bin)
    };
  });
  return formattedData;
});
exports.getFormattedData = getFormattedData;

var getData = function (props) {
  var bins = props.bins,
      data = props.data,
      x = props.x;
  var dataIsPreformatted = data.some(function (_ref5) {
    var _y = _ref5._y;
    return !(0, _isNil2.default)(_y);
  });
  var formattedData = dataIsPreformatted ? data : getFormattedData({
    data: data,
    x: x,
    bins: bins
  });
  return _victoryCore.Data.getData(_objectSpread({}, props, {
    data: formattedData,
    x: "x"
  }));
};

exports.getData = getData;

var getDomain = function (props, axis) {
  var data = getData(props);

  if (!data.length) {
    return [0, 1];
  }

  if (axis === "x") {
    var firstBin = data[0];
    var lastBin = data[data.length - 1];
    return _victoryCore.Domain.getDomainWithZero(_objectSpread({}, props, {
      data: [{
        x: firstBin.x0
      }, {
        x: lastBin.x1
      }],
      x: "x"
    }), "x");
  }

  return props.data.length ? _victoryCore.Domain.getDomainWithZero(_objectSpread({}, props, {
    data: data
  }), "y") : [0, 1];
};

exports.getDomain = getDomain;

var getCalculatedValues = function (props) {
  var theme = props.theme;
  var defaultStyles = theme && theme.histogram && theme.histogram.style ? theme.histogram.style : {};

  var style = _victoryCore.Helpers.getStyles(props.style, defaultStyles);

  var data = getData(props);
  var range = props.range || {
    x: _victoryCore.Helpers.getRange(props, "x"),
    y: _victoryCore.Helpers.getRange(props, "y")
  };
  var domain = {
    x: getDomain(props, "x"),
    y: getDomain(props, "y")
  };
  var scale = {
    x: _victoryCore.Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: _victoryCore.Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  return {
    style: style,
    data: data,
    scale: scale,
    domain: domain
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(props, fallbackProps, "histogram");

  props = (0, _assign2.default)({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      binSpacing = _props.binSpacing,
      cornerRadius = _props.cornerRadius,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      height = _props.height,
      horizontal = _props.horizontal,
      padding = _props.padding,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width,
      labels = _props.labels,
      name = _props.name,
      getPath = _props.getPath;
  var initialChildProps = {
    parent: {
      horizontal: horizontal,
      domain: domain,
      scale: scale,
      width: width,
      height: height,
      data: data,
      standalone: standalone,
      name: name,
      theme: theme,
      padding: padding,
      style: style.parent
    }
  };

  var getDistance = function (datum) {
    var current = scale.x(datum.x0);
    var next = scale.x(datum.x1);
    return Math.abs(next - current);
  };

  var getBarWidth = function (datum) {
    if (binSpacing) {
      return getDistance(datum) - binSpacing;
    }

    return getDistance(datum);
  };

  return data.reduce(function (childProps, datum, index) {
    var eventKey = !(0, _isNil2.default)(datum.eventKey) ? datum.eventKey : index;

    var _getBarPosition = (0, _victoryBar.getBarPosition)(props, datum),
        x = _getBarPosition.x,
        y = _getBarPosition.y,
        y0 = _getBarPosition.y0,
        x0 = _getBarPosition.x0;

    var barWidth = getBarWidth(datum);
    var dataProps = {
      alignment: "middle",
      barWidth: barWidth,
      cornerRadius: cornerRadius,
      data: data,
      datum: datum,
      horizontal: horizontal,
      index: index,
      scale: scale,
      style: style.data,
      width: width,
      height: height,
      x: x,
      y: y,
      y0: y0,
      x0: x0,
      getPath: getPath
    };
    childProps[eventKey] = {
      data: dataProps
    };

    var text = _victoryCore.LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      childProps[eventKey].labels = _victoryCore.LabelHelpers.getProps(props, index);
    }

    return childProps;
  }, initialChildProps);
};

exports.getBaseProps = getBaseProps;