export declare enum CloudConfigFileTypes {
    YAML = 1,
    JSON = 2,
    TF = 3
}
export interface FileStructureTree {
    nodes: FileStructureNode[];
}
export interface MapsDocIdToTree {
    [index: number]: FileStructureTree;
}
export interface LineLocation {
    line: number;
    columnStart: number;
    columnEnd: number;
}
export interface FileStructureNode {
    key: string;
    lineLocation: LineLocation;
    values: FileStructureNode[] | string;
}
export interface PathDetails {
    docId: number;
    path: string[];
}
