"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzeStatically = void 0;
const analyzer = require("./analyzer");
const dependency_tree_1 = require("./dependency-tree");
const parser_1 = require("./parser");
const response_builder_1 = require("./response-builder");
async function analyzeStatically(targetImage, dockerfileAnalysis, imageType, imagePath, excludeBaseImageVulns, globsToFind, appScan) {
    const staticAnalysis = await analyzer.analyzeStatically(targetImage, dockerfileAnalysis, imageType, imagePath, globsToFind, appScan);
    const parsedAnalysisResult = parser_1.parseAnalysisResults(targetImage, staticAnalysis);
    /** @deprecated Should try to build a dependency graph instead. */
    const dependenciesTree = await dependency_tree_1.buildTree(targetImage, parsedAnalysisResult.type, parsedAnalysisResult.depInfosList, parsedAnalysisResult.targetOS);
    const analysis = Object.assign(Object.assign({}, staticAnalysis), { depTree: dependenciesTree, imageId: parsedAnalysisResult.imageId, imageLayers: parsedAnalysisResult.imageLayers, packageManager: parsedAnalysisResult.type });
    return response_builder_1.buildResponse(analysis, dockerfileAnalysis, excludeBaseImageVulns);
}
exports.analyzeStatically = analyzeStatically;
//# sourceMappingURL=static.js.map