/**
 * Returns the value with '' around it.  Any 's will be escaped \' in the output
 */
export declare function calc(exp: string): string;
/**
 * Returns the value with '' around it.  Any 's will be escaped \' in the output
 */
export declare function quote(val: number | string): string;
/**
 * Returns the value with !important on the end.  If the value provided is a CSSHelper, it will
 * be converted to a string by necessity, but will look like it is the original type to TypeScript.
 */
export declare function important<T>(val: T): T;
/**
 * Returns the string in a url()
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/url
 */
export declare function url(val: string): string;
/**
 * Returns the value as a string or an empty string if null or undefined.
 * @param value
 * @param fallbackValue
 */
export declare function coalesce<T extends number | string>(value: T | undefined): string;
