import { CSSTransformFunction } from './types';
/**
 * The CSS transform property lets you modify the coordinate space of the CSS visual formatting model. Using it, elements can be translated, rotated, scaled, and skewed.
 * Returns the transforms as a delimited string by space or returns 'none' if no arguments are provided
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/transform
 */
export declare function transform(...transforms: CSSTransformFunction[]): CSSTransformFunction;
export declare const matrix: (a: number, b: number, c: number, d: number, tx: number, ty: number) => string;
export declare const matrix3d: (a1: number, b1: number, c1: number, d1: number, a2: number, b2: number, c2: number, d2: number, a3: number, b3: number, c3: number, d3: number, a4: number, b4: number, c4: number, d4: number) => string;
export declare const perspective: (value: string | number) => string;
export declare const rotate: (z: string | number) => string;
export declare const rotate3d: (x: string | number, y: string | number, z: string | number) => string;
export declare const rotateX: (x: string | number) => string;
export declare const rotateY: (y: string | number) => string;
export declare const rotateZ: (z: string | number) => string;
export declare const scale: (x: number, y?: number | undefined) => string;
export declare const scale3d: (x: number, y: number, z: number) => string;
export declare const scaleX: (x: number) => string;
export declare const scaleY: (y: number) => string;
export declare const scaleZ: (z: number) => string;
export declare const skew: (x: string | number, y?: string | number | undefined) => string;
export declare const skewX: (x: string | number) => string;
export declare const skewY: (y: string | number) => string;
export declare const translate: (x: string | number, y?: string | number | undefined) => string;
export declare const translate3d: (x: string | number, y: string | number, z: string | number) => string;
export declare const translateX: (x: string | number) => string;
export declare const translateY: (y: string | number) => string;
export declare const translateZ: (z: string | number) => string;
