"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateRelevantFixes = void 0;
const is_defined_1 = require("./is-defined");
const standardize_package_name_1 = require("./standardize-package-name");
function calculateRelevantFixes(requirements, updates, type) {
    const lowerCasedUpdates = {};
    const topLevelDeps = requirements.map(({ name }) => name).filter(is_defined_1.isDefined);
    Object.keys(updates).forEach((update) => {
        const { upgradeTo } = updates[update];
        const [pkgName] = update.split('@');
        const isTransitive = topLevelDeps.indexOf(standardize_package_name_1.standardizePackageName(pkgName)) < 0;
        if (type === 'transitive-pins' ? isTransitive : !isTransitive) {
            const [name, newVersion] = upgradeTo.split('@');
            lowerCasedUpdates[update] = Object.assign(Object.assign({}, updates[update]), { upgradeTo: `${standardize_package_name_1.standardizePackageName(name)}@${newVersion}` });
        }
    });
    return lowerCasedUpdates;
}
exports.calculateRelevantFixes = calculateRelevantFixes;
//# sourceMappingURL=calculate-relevant-fixes.js.map