"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generatePins = void 0;
const calculate_relevant_fixes_1 = require("./calculate-relevant-fixes");
const is_defined_1 = require("./is-defined");
const standardize_package_name_1 = require("./standardize-package-name");
function generatePins(requirements, updates, referenceFileInChanges) {
    // Lowercase the upgrades object. This might be overly defensive, given that
    // we control this input internally, but its a low cost guard rail. Outputs a
    // mapping of upgrade to -> from, instead of the nested upgradeTo object.
    const standardizedPins = calculate_relevant_fixes_1.calculateRelevantFixes(requirements, updates, 'transitive-pins');
    if (Object.keys(standardizedPins).length === 0) {
        return {
            pinnedRequirements: [],
            changes: [],
        };
    }
    const changes = [];
    const pinnedRequirements = Object.keys(standardizedPins)
        .map((pkgNameAtVersion) => {
        const [pkgName, version] = pkgNameAtVersion.split('@');
        const newVersion = standardizedPins[pkgNameAtVersion].upgradeTo.split('@')[1];
        const newRequirement = `${standardize_package_name_1.standardizePackageName(pkgName)}>=${newVersion}`;
        changes.push({
            from: `${pkgName}@${version}`,
            to: `${pkgName}@${newVersion}`,
            issueIds: standardizedPins[pkgNameAtVersion].vulns,
            success: true,
            userMessage: `Pinned ${standardize_package_name_1.standardizePackageName(pkgName)} from ${version} to ${newVersion}${referenceFileInChanges ? ` (pinned in ${referenceFileInChanges})` : ''}`,
        });
        return `${newRequirement} # not directly required, pinned by Snyk to avoid a vulnerability`;
    })
        .filter(is_defined_1.isDefined);
    return {
        pinnedRequirements,
        changes,
    };
}
exports.generatePins = generatePins;
//# sourceMappingURL=generate-pins.js.map