"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapEntitiesPerHandlerType = void 0;
const debugLib = require("debug");
const get_handler_type_1 = require("./get-handler-type");
const supported_handler_types_1 = require("./supported-handler-types");
const debug = debugLib('snyk-fix:python');
function mapEntitiesPerHandlerType(entities) {
    const entitiesPerType = {
        [supported_handler_types_1.SUPPORTED_HANDLER_TYPES.REQUIREMENTS]: [],
        [supported_handler_types_1.SUPPORTED_HANDLER_TYPES.PIPFILE]: [],
    };
    const skipped = [];
    for (const entity of entities) {
        const type = get_handler_type_1.getHandlerType(entity);
        if (type) {
            entitiesPerType[type].push(entity);
            continue;
        }
        const userMessage = `${entity.scanResult.identity.targetFile} is not supported`;
        debug(userMessage);
        skipped.push({ original: entity, userMessage });
    }
    return { entitiesPerType, skipped };
}
exports.mapEntitiesPerHandlerType = mapEntitiesPerHandlerType;
//# sourceMappingURL=map-entities-per-handler-type.js.map