/// <reference types="node" />
import { Stats } from 'fs';
import { Filename } from './path';
export declare class DirEntry {
    name: Filename;
    mode: number;
    isBlockDevice(): boolean;
    isCharacterDevice(): boolean;
    isDirectory(): boolean;
    isFIFO(): boolean;
    isFile(): boolean;
    isSocket(): boolean;
    isSymbolicLink(): boolean;
}
export declare class StatEntry {
    dev: number;
    ino: number;
    mode: number;
    nlink: number;
    rdev: number;
    blocks: number;
    isBlockDevice(): boolean;
    isCharacterDevice(): boolean;
    isDirectory(): boolean;
    isFIFO(): boolean;
    isFile(): boolean;
    isSocket(): boolean;
    isSymbolicLink(): boolean;
}
export declare function makeDefaultStats(): StatEntry & {
    readonly uid: 0;
    readonly gid: 0;
    readonly size: 0;
    readonly blksize: 0;
    readonly atimeMs: 0;
    readonly mtimeMs: 0;
    readonly ctimeMs: 0;
    readonly birthtimeMs: 0;
    readonly atime: Date;
    readonly mtime: Date;
    readonly ctime: Date;
    readonly birthtime: Date;
    readonly mode: number;
};
export declare function makeEmptyStats(): StatEntry & {
    readonly uid: 0;
    readonly gid: 0;
    readonly size: 0;
    readonly blksize: 0;
    readonly atimeMs: 0;
    readonly mtimeMs: 0;
    readonly ctimeMs: 0;
    readonly birthtimeMs: 0;
    readonly atime: Date;
    readonly mtime: Date;
    readonly ctime: Date;
    readonly birthtime: Date;
    readonly mode: number;
} & {
    readonly nlink: 0;
    readonly blocks: 0;
    readonly mode: 0;
};
export declare function areStatsEqual(a: Stats, b: Stats): boolean;
