"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editable = void 0;

var React = _interopRequireWildcard(require("react"));

var _EditColumn = require("../../EditColumn");

var _table = _interopRequireDefault(require("@patternfly/react-styles/css/components/Table/table"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var editable = function editable(label, _ref) {
  var rowIndex = _ref.rowIndex,
      rowData = _ref.rowData,
      column = _ref.column;
  var onRowEdit = column.extraParams.onRowEdit;

  var toggleEditMode = function toggleEditMode(event, type) {
    var validationErrors = {};

    if (type === 'save') {
      validationErrors = rowData.rowEditValidationRules && rowData.rowEditValidationRules.reduce(function (acc, rule) {
        var invalidCells = rowData.cells.filter(function (cellData) {
          var testValue = cellData.props.editableValue === '' ? '' : cellData.props.editableValue || cellData.props.value;
          var failedValidation = !rule.validator(testValue);

          if (failedValidation) {
            cellData.props.isValid = false;
          }

          return failedValidation;
        });

        if (invalidCells.length) {
          acc[rule.name] = invalidCells.map(function (cell) {
            return cell.props.name;
          });
        }

        return acc;
      }, {});
    } // tslint:disable-next-line:no-unused-expression


    onRowEdit(event, type, rowData && rowData.isEditable, rowIndex, validationErrors);
  };
  /**
   * @param {number} identifier identifier used for the row
   * @param {RowEditType} actionType the type of row edit action
   */


  function getAriaLabelTxt(identifier, actionType) {
    var result;

    switch (actionType) {
      case 'cancel':
        result = "Cancel row edits for row ".concat(identifier);
        break;

      case 'save':
        result = "Save row edits for row ".concat(identifier);
        break;

      default:
        result = "Place row ".concat(identifier, " in edit mode");
    }

    return result;
  }

  return {
    className: _table["default"].tableInlineEditAction,
    component: 'td',
    isVisible: true,
    children: React.createElement(_EditColumn.EditColumn, {
      saveAriaLabel: rowData && rowData.rowSaveBtnAriaLabel && rowData.rowSaveBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'save'),
      cancelAriaLabel: rowData && rowData.rowCancelBtnAriaLabel && rowData.rowCancelBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'cancel'),
      editAriaLabel: rowData && rowData.rowEditBtnAriaLabel && rowData.rowEditBtnAriaLabel(rowIndex) || getAriaLabelTxt(rowIndex, 'edit'),
      valid: rowData && rowData.isValid,
      editing: rowData && rowData.isEditable,
      onClick: toggleEditMode
    })
  };
};

exports.editable = editable;
//# sourceMappingURL=editable.js.map