/**
 * @module Box helpers
 * Having top, left, bottom, right seperated makes it easier to override and maintain individual properties
 */
import * as types from 'typestyle/lib/types';
/**
 * For `number` we assume pixels e.g. 5 => '5px'
 * For `string` *you* should provide the unit e.g. '5px'
 */
export declare type BoxUnit = number | string;
/**
 * A box function is something that can take:
 * - all
 * - topAndBottom + leftRight
 * - top + right + bottom + left
 */
export interface BoxFunction<T> {
    (all: BoxUnit): T;
    (topAndBottom: BoxUnit, leftAndRight: BoxUnit): T;
    (top: BoxUnit, right: BoxUnit, bottom: BoxUnit, left: BoxUnit): T;
}
export declare const padding: BoxFunction<{
    paddingTop: string;
    paddingRight: string;
    paddingBottom: string;
    paddingLeft: string;
}>;
export declare const margin: BoxFunction<{
    marginTop: string;
    marginRight: string;
    marginBottom: string;
    marginLeft: string;
}>;
export declare const border: BoxFunction<{
    borderTop: string;
    borderRight: string;
    borderBottom: string;
    borderLeft: string;
}>;
/**
 * Puts a vertical margin between each child
 */
export declare const verticallySpaced: (margin: string | number) => types.CSSProperties;
/**
 * Puts a horizontal margin between each child
 */
export declare const horizontallySpaced: (margin: string | number) => types.CSSProperties;
/**
 * Puts a (horizontal AND vertical) margin between each child
 */
export declare const gridSpaced: (margin: string | number) => types.CSSProperties;
/**
 * Gives this element the same size as the nearest offsetParent
 */
export declare const fillParent: {
    width: string;
    height: string;
};
/** mixin: maxWidth */
export declare const maxWidth: (value: string | number) => {
    maxWidth: string;
};
/** mixin: maxHeight */
export declare const maxHeight: (value: string | number) => {
    maxHeight: string;
};
/**
 * Block elements: Centering *self* using margins
 */
export declare const horizontallyCenterSelf: {
    marginLeft: string;
    marginRight: string;
};
/**
 * Block elements: Centering *child* elements using textAlign
 */
export declare const horizontallyCenterChildren: {
    textAlign: "center";
};
/** mixin: height */
export declare const height: (value: string | number) => {
    height: string;
};
/** mixin: width */
export declare const width: (value: string | number) => {
    width: string;
};
