"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertLegacyTestResultToNew = void 0;
function convertVulnerabilities(vulns) {
    const issuesData = {};
    const issues = [];
    vulns.forEach((vuln) => {
        issuesData[vuln.id] = {
            id: vuln.id,
            severity: vuln.severity,
            title: vuln.title,
        };
        issues.push({
            pkgName: vuln.packageName,
            pkgVersion: vuln.version,
            issueId: vuln.id,
            // TODO: add fixInfo when needed
            fixInfo: {},
        });
    });
    return { issuesData, issues };
}
function convertLegacyTestResultToNew(testResult) {
    const { issues, issuesData } = convertVulnerabilities(testResult.vulnerabilities);
    return {
        issuesData,
        issues,
        remediation: testResult.remediation,
        // TODO: grab this once Ecosystems flow starts sending back ScanResult
        depGraphData: {},
    };
}
exports.convertLegacyTestResultToNew = convertLegacyTestResultToNew;
//# sourceMappingURL=convert-legacy-test-result-to-new.js.map