import { CustomError } from '../../../../../lib/errors';
import { IacFileData, IacFileParsed } from '../types';
export declare const REQUIRED_K8S_FIELDS: string[];
export declare const REQUIRED_CLOUDFORMATION_FIELDS: string[];
export declare function assertHelmAndThrow(fileData: IacFileData): void;
export declare function detectConfigType(fileData: IacFileData, parsedIacFiles: any[]): IacFileParsed[];
export declare function checkRequiredFieldsMatch(parsedDocument: any, requiredFields: string[]): boolean;
export declare class HelmFileNotSupportedError extends CustomError {
    constructor(filename: string);
}
export declare class MissingRequiredFieldsInKubernetesYamlError extends CustomError {
    constructor(filename: string);
}
export declare class FailedToDetectYamlConfigError extends CustomError {
    constructor(filename: string);
}
