"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.test = void 0;
const assert_iac_options_flag_1 = require("./iac-local-execution/assert-iac-options-flag");
const measurable_methods_1 = require("./iac-local-execution/measurable-methods");
const lib_1 = require("../../../lib");
const get_iac_org_settings_1 = require("./iac-local-execution/org-settings/get-iac-org-settings");
const feature_flags_1 = require("../../../lib/feature-flags");
const config = require("../../../lib/config");
const camelCase = require('lodash.camelcase');
/**
 * Shim around the new local execution test path and the legacy remote
 * test flow. We also locally deal with the way the legacy test flow exposes
 * the scanned files via the `options.iacDirFiles` object here so that
 * in the new flow we do not mutate the options object.
 */
async function test(pathToScan, options) {
    var _a;
    // Ensure that all flags are correct. We do this to ensure that the
    // caller doesn't accidentally mistype --experimental and send their
    // configuration files to our backend by accident.
    assert_iac_options_flag_1.assertIaCOptionsFlags(process.argv);
    const iacOrgSettings = await get_iac_org_settings_1.getIacOrgSettings(options.org || config.org);
    const shouldOptOutFromLocalExec = await feature_flags_1.isFeatureFlagSupportedForOrg(camelCase('opt-out-from-local-exec-iac'), iacOrgSettings.meta.org);
    if (shouldOptOutFromLocalExec.ok || options.legacy) {
        // this path allows users to opt-out from the local IaC scan which is GA and continue using the remote-processing legacy flow.
        const results = await lib_1.test(pathToScan, options);
        return {
            failures: (_a = options.iacDirFiles) === null || _a === void 0 ? void 0 : _a.filter((file) => !!file.failureReason),
            results,
        };
    }
    return measurable_methods_1.localTest(pathToScan, options);
}
exports.test = test;
//# sourceMappingURL=iac-test-shim.js.map