"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateTestOptions = void 0;
const chalk_1 = require("chalk");
const common_1 = require("../../../lib/snyk-test/common");
const fail_on_error_ts_1 = require("../../../lib/errors/fail-on-error.ts");
function validateTestOptions(options) {
    if (options.severityThreshold &&
        !validateSeverityThreshold(options.severityThreshold)) {
        throw new Error('INVALID_SEVERITY_THRESHOLD');
    }
    if (options.failOn && !validateFailOn(options.failOn)) {
        const error = new fail_on_error_ts_1.FailOnError();
        throw chalk_1.default.red.bold(error.message);
    }
}
exports.validateTestOptions = validateTestOptions;
function validateSeverityThreshold(severityThreshold) {
    return common_1.SEVERITIES.map((s) => s.verboseName).indexOf(severityThreshold) > -1;
}
function validateFailOn(arg) {
    return Object.keys(common_1.FAIL_ON).includes(arg);
}
//# sourceMappingURL=validate-test-options.js.map