"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isVulnFixable = exports.isVulnPatchable = exports.isVulnUpgradable = exports.hasPatches = exports.isPatchable = exports.hasUpgrades = exports.isUpgradable = exports.hasFixes = exports.isFixable = exports.isNewVuln = void 0;
// check if vuln was published in the last month
function isNewVuln(vuln) {
    const MONTH = 30 * 24 * 60 * 60 * 1000;
    const publicationTime = new Date(vuln.publicationTime).getTime();
    return publicationTime > Date.now() - MONTH;
}
exports.isNewVuln = isNewVuln;
function isFixable(testResult) {
    return isUpgradable(testResult) || isPatchable(testResult);
}
exports.isFixable = isFixable;
function hasFixes(testResults) {
    return testResults.some(isFixable);
}
exports.hasFixes = hasFixes;
function isUpgradable(testResult) {
    if (testResult.remediation) {
        const { remediation: { upgrade = {}, pin = {} }, } = testResult;
        return Object.keys(upgrade).length > 0 || Object.keys(pin).length > 0;
    }
    // if remediation is not available, fallback on vuln properties
    const { vulnerabilities = {} } = testResult;
    return vulnerabilities.some(isVulnUpgradable);
}
exports.isUpgradable = isUpgradable;
function hasUpgrades(testResults) {
    return testResults.some(isUpgradable);
}
exports.hasUpgrades = hasUpgrades;
function isPatchable(testResult) {
    if (testResult.remediation) {
        const { remediation: { patch = {} }, } = testResult;
        return Object.keys(patch).length > 0;
    }
    // if remediation is not available, fallback on vuln properties
    const { vulnerabilities = {} } = testResult;
    return vulnerabilities.some(isVulnPatchable);
}
exports.isPatchable = isPatchable;
function hasPatches(testResults) {
    return testResults.some(isPatchable);
}
exports.hasPatches = hasPatches;
function isVulnUpgradable(vuln) {
    return vuln.isUpgradable || vuln.isPinnable;
}
exports.isVulnUpgradable = isVulnUpgradable;
function isVulnPatchable(vuln) {
    return vuln.isPatchable;
}
exports.isVulnPatchable = isVulnPatchable;
function isVulnFixable(vuln) {
    return isVulnUpgradable(vuln) || isVulnPatchable(vuln);
}
exports.isVulnFixable = isVulnFixable;
//# sourceMappingURL=vuln-helpers.js.map