"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageNotFoundError = void 0;
const custom_error_1 = require("./custom-error");
class DockerImageNotFoundError extends custom_error_1.CustomError {
    constructor(image) {
        const message = `Failed to scan image "${image}". Please make sure the image and/or repository exist, and that you are using the correct credentials.`;
        super(message);
        this.code = DockerImageNotFoundError.ERROR_CODE;
        this.userMessage = message;
    }
}
exports.DockerImageNotFoundError = DockerImageNotFoundError;
DockerImageNotFoundError.ERROR_CODE = 404;
//# sourceMappingURL=docker-image-not-found-error.js.map