export declare function assembleQueryString(options: any): {
    org: string;
    severityThreshold?: boolean | undefined;
    ignorePolicy?: boolean | undefined;
} | null;
export declare enum SEVERITY {
    LOW = "low",
    MEDIUM = "medium",
    HIGH = "high",
    CRITICAL = "critical"
}
export declare const SEVERITIES: Array<{
    verboseName: SEVERITY;
    value: number;
}>;
export declare const severitiesColourMapping: {
    low: {
        colorFunc(text: any): string;
    };
    medium: {
        colorFunc(text: any): string;
    };
    high: {
        colorFunc(text: any): string;
    };
    critical: {
        colorFunc(text: any): string;
    };
};
export declare const legacySeveritiesColourMapping: {
    low: {
        colorFunc(text: any): string;
    };
    medium: {
        colorFunc(text: any): string;
    };
    high: {
        colorFunc(text: any): string;
    };
    critical: {
        colorFunc(text: any): string;
    };
};
export declare const defaultSeverityColor: {
    colorFunc(text: any): string;
};
export declare function getSeveritiesColour(severity: string): any;
export declare function getLegacySeveritiesColour(severity: string): any;
export declare enum FAIL_ON {
    all = "all",
    upgradable = "upgradable",
    patchable = "patchable"
}
export declare type FailOn = 'all' | 'upgradable' | 'patchable';
