/// <reference types="node" />
import { SupportedPackageManagers } from './package-managers';
import { IacProjectTypes, IacFileTypes } from './iac/constants';
import { legacyCommon as legacyApi } from '@snyk/cli-interface';
import { SEVERITY } from './snyk-test/legacy';
import { FailOn } from './snyk-test/common';
export interface DepDict {
    [name: string]: DepTree;
}
export declare type DepTree = legacyApi.DepTree;
export declare type ShowVulnPaths = 'none' | 'some' | 'all';
export interface TestOptions {
    traverseNodeModules?: boolean;
    pruneRepeatedSubdependencies?: boolean;
    showVulnPaths: ShowVulnPaths;
    failOn?: FailOn;
    reachableVulns?: boolean;
    reachableVulnsTimeout?: number;
    initScript?: string;
    yarnWorkspaces?: boolean;
    command?: string;
    testDepGraphDockerEndpoint?: string | null;
    isDockerUser?: boolean;
    /** @deprecated Only used by the legacy `iac test` flow remove once local exec path is GA */
    iacDirFiles?: IacFileInDirectory[];
}
export interface ProtectOptions {
    interactive?: boolean;
    newPolicy: boolean;
}
export interface Contributor {
    userId: string;
    lastCommitDate: string;
}
export interface PolicyOptions {
    'ignore-policy'?: boolean;
    'trust-policies'?: boolean;
    'policy-path'?: string;
    loose?: boolean;
}
export interface Options {
    org?: string | null;
    path: string;
    docker?: boolean;
    iac?: boolean;
    code?: boolean;
    source?: boolean;
    file?: string;
    policy?: string;
    json?: boolean;
    vulnEndpoint?: string;
    projectName?: string;
    insecure?: boolean;
    'dry-run'?: boolean;
    allSubProjects?: boolean;
    'project-name'?: string;
    'show-vulnerable-paths'?: string;
    packageManager?: SupportedPackageManagers;
    advertiseSubprojectsCount?: number;
    projectNames?: string[];
    severityThreshold?: SEVERITY;
    dev?: boolean;
    'print-deps'?: boolean;
    'remote-repo-url'?: string;
    scanAllUnmanaged?: boolean;
    allProjects?: boolean;
    detectionDepth?: number;
    exclude?: string;
    strictOutOfSync?: boolean;
    experimental?: boolean;
    'app-vulns'?: boolean;
    debug?: boolean;
    sarif?: boolean;
    'group-issues'?: boolean;
    quiet?: boolean;
}
export interface MonitorOptions {
    id?: string;
    docker?: boolean;
    file?: string;
    policy?: string;
    json?: boolean;
    allSubProjects?: boolean;
    'project-name'?: string;
    'print-deps'?: boolean;
    'experimental-dep-graph'?: boolean;
    scanAllUnmanaged?: boolean;
    allProjects?: boolean;
    pruneRepeatedSubdependencies?: boolean;
    experimental?: boolean;
    'app-vulns'?: boolean;
    reachableVulns?: boolean;
    reachableVulnsTimeout?: number;
    initScript?: string;
    yarnWorkspaces?: boolean;
}
export interface MonitorMeta {
    method: 'cli' | 'wizard';
    packageManager: SupportedPackageManagers;
    'policy-path': string;
    'project-name': string;
    isDocker: boolean;
    prune: boolean;
    'experimental-dep-graph'?: boolean;
    'remote-repo-url'?: string;
}
export interface PackageJson {
    scripts: any;
    snyk: boolean;
    dependencies: any;
    devDependencies: any;
}
export interface MonitorResult {
    org?: string;
    id: string;
    path: string;
    licensesPolicy: any;
    uri: string;
    isMonitored: boolean;
    trialStarted: boolean;
}
export interface SpinnerOptions {
    stream?: NodeJS.WriteStream;
    tty?: any;
    string?: string;
    interval?: any;
    delay?: any;
    label?: string;
    unref?: any;
    cleanup?: any;
}
export interface OutputDataTypes {
    stdout: any;
    stringifiedData: string;
    stringifiedJsonData: string;
    stringifiedSarifData: string;
}
export declare type SupportedProjectTypes = IacProjectTypes | SupportedPackageManagers;
export declare type SupportedUserReachableFacingCliArgs = 'all-projects' | 'all-sub-projects' | 'detection-depth' | 'docker' | 'dry-run' | 'fail-on' | 'file' | 'gradle-sub-project' | 'ignore-policy' | 'init-script' | 'integration-name' | 'integration-version' | 'json' | 'package-manager' | 'packages-folder' | 'policy' | 'project-name' | 'prune-repeated-subdependencies' | 'reachable' | 'reachable-timeout' | 'reachable-vulns' | 'reachable-vulns-timeout' | 'rules' | 'scan-all-unmanaged' | 'severity-threshold' | 'show-vulnerable-paths' | 'skip-unresolved' | 'strict-out-of-sync' | 'sub-project' | 'trust-policies' | 'yarn-workspaces';
export declare enum SupportedCliCommands {
    version = "version",
    help = "help",
    test = "test",
    monitor = "monitor",
    fix = "fix",
    protect = "protect",
    policy = "policy",
    ignore = "ignore",
    wizard = "wizard",
    woof = "woof"
}
export interface IacFileInDirectory {
    filePath: string;
    fileType: IacFileTypes;
    projectType?: IacProjectTypes;
    failureReason?: string;
}
