"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPreviewBuilder = getPreviewBuilder;

var _path = _interopRequireDefault(require("path"));

var _coreCommon = require("@storybook/core-common");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var DEFAULT_WEBPACK = 'webpack4';

async function getPreviewBuilder(configDir) {
  var main = _path.default.resolve(configDir, 'main');

  var mainFile = (0, _coreCommon.getInterpretedFile)(main);

  var _ref = mainFile ? (0, _coreCommon.serverRequire)(mainFile) : {
    core: null
  },
      core = _ref.core;

  var builder = (core === null || core === void 0 ? void 0 : core.builder) || DEFAULT_WEBPACK;
  var previewBuilder = await Promise.resolve(`@storybook/builder-${builder}`).then(function (s) {
    return _interopRequireWildcard(require(s));
  });
  return previewBuilder;
}