import { RemoteBundle } from './http';
import { AnalysisSeverity, IGitBundle, IFileBundle, IBundleResult } from './interfaces/analysis-result.interface';
import { FolderOptions, GitOptions } from './interfaces/analysis-options.interface';
import { RequestOptions } from './interfaces/http-options.interface';
import { ISupportedFiles } from './interfaces/files.interface';
export declare function analyzeBundle({ baseURL, sessionToken, includeLint, severity, bundleId, oAuthToken, username, limitToFiles, source, reachability, }: {
    baseURL: string;
    sessionToken: string;
    includeLint: boolean;
    severity: AnalysisSeverity;
    bundleId: string;
    oAuthToken?: string;
    username?: string;
    limitToFiles?: string[];
    source: string;
    reachability?: boolean;
}, requestOptions?: RequestOptions): Promise<IBundleResult>;
export declare function analyzeFolders(options: FolderOptions): Promise<IFileBundle>;
export declare function extendAnalysis(bundle: IFileBundle, filePaths: string[], maxPayload: number | undefined, source: string): Promise<IFileBundle | null>;
export declare function analyzeGit(options: GitOptions, requestOptions?: RequestOptions): Promise<IGitBundle>;
interface CreateBundleFromFoldersOptions extends FolderOptions {
    supportedFiles?: ISupportedFiles;
    baseDir?: string;
    fileIgnores?: string[];
}
/**
 * Creates a remote bundle and returns response from the bundle API
 *
 * @param {CreateBundleFromFoldersOptions} options
 * @returns {Promise<RemoteBundle | null>}
 */
export declare function createBundleFromFolders(options: CreateBundleFromFoldersOptions): Promise<RemoteBundle | null>;
export {};
