"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_ERROR_MESSAGES = exports.ErrorCodes = exports.DCIGNORE_DRAFTS = exports.IGNORE_FILES_NAMES = exports.IGNORES_DEFAULT = exports.MAX_UPLOAD_ATTEMPTS = exports.CACHE_KEY = exports.EXCLUDED_NAMES = exports.DCIGNORE_FILENAME = exports.GITIGNORE_FILENAME = exports.GIT_FILENAME = exports.ENCODE_TYPE = exports.HASH_ALGORITHM = exports.apiPath = exports.defaultBaseURL = exports.MAX_PAYLOAD = void 0;
const dcignore_1 = require("@deepcode/dcignore");
exports.MAX_PAYLOAD = 4 * 1024 * 1024;
exports.defaultBaseURL = 'https://www.deepcode.ai';
exports.apiPath = '/publicapi';
exports.HASH_ALGORITHM = 'sha256';
exports.ENCODE_TYPE = 'hex';
exports.GIT_FILENAME = '.git';
exports.GITIGNORE_FILENAME = '.gitignore';
exports.DCIGNORE_FILENAME = '.dcignore';
exports.EXCLUDED_NAMES = [exports.GIT_FILENAME, exports.GITIGNORE_FILENAME, exports.DCIGNORE_FILENAME];
exports.CACHE_KEY = '.dccache';
exports.MAX_UPLOAD_ATTEMPTS = 5;
exports.IGNORES_DEFAULT = [`**/${exports.GIT_FILENAME}/**`];
exports.IGNORE_FILES_NAMES = [exports.GITIGNORE_FILENAME, exports.DCIGNORE_FILENAME];
exports.DCIGNORE_DRAFTS = {
    custom: dcignore_1.CustomDCIgnore,
    default: dcignore_1.DefaultDCIgnore,
};
// eslint-disable-next-line no-shadow
var ErrorCodes;
(function (ErrorCodes) {
    ErrorCodes[ErrorCodes["loginInProgress"] = 304] = "loginInProgress";
    ErrorCodes[ErrorCodes["unauthorizedContent"] = 400] = "unauthorizedContent";
    ErrorCodes[ErrorCodes["unauthorizedUser"] = 401] = "unauthorizedUser";
    ErrorCodes[ErrorCodes["unauthorizedBundleAccess"] = 403] = "unauthorizedBundleAccess";
    ErrorCodes[ErrorCodes["notFound"] = 404] = "notFound";
    ErrorCodes[ErrorCodes["bigPayload"] = 413] = "bigPayload";
    ErrorCodes[ErrorCodes["connectionRefused"] = 421] = "connectionRefused";
    ErrorCodes[ErrorCodes["dnsNotFound"] = 452] = "dnsNotFound";
    ErrorCodes[ErrorCodes["serverError"] = 500] = "serverError";
    ErrorCodes[ErrorCodes["badGateway"] = 502] = "badGateway";
    ErrorCodes[ErrorCodes["serviceUnavailable"] = 503] = "serviceUnavailable";
    ErrorCodes[ErrorCodes["timeout"] = 504] = "timeout";
})(ErrorCodes = exports.ErrorCodes || (exports.ErrorCodes = {}));
exports.DEFAULT_ERROR_MESSAGES = {
    [ErrorCodes.serverError]: 'Unexpected server error',
    [ErrorCodes.badGateway]: 'Bad gateway',
    [ErrorCodes.serviceUnavailable]: 'Service unavailable',
    [ErrorCodes.timeout]: 'Timeout occured. Try again later.',
    [ErrorCodes.dnsNotFound]: '[Connection issue] Could not resolve domain',
    [ErrorCodes.connectionRefused]: '[Connection issue] Connection refused',
    [ErrorCodes.loginInProgress]: 'Login has not been confirmed yet',
    [ErrorCodes.unauthorizedContent]: 'Unauthorized request to specific content',
    [ErrorCodes.unauthorizedUser]: 'Missing, revoked or inactive token',
    [ErrorCodes.unauthorizedBundleAccess]: 'Unauthorized access to requested bundle analysis',
    [ErrorCodes.notFound]: 'Not found',
    [ErrorCodes.bigPayload]: `Payload too large (max is ${exports.MAX_PAYLOAD}b)`,
};
//# sourceMappingURL=constants.js.map