import { AxiosError } from 'axios';
import { ErrorCodes, GenericErrorTypes } from './constants';
import { IFiles, IFileContent, ISupportedFiles } from './interfaces/files.interface';
import { IAnalysisResult } from './interfaces/analysis-result.interface';
import { RequestOptions } from './interfaces/http-options.interface';
declare type ResultSuccess<T> = {
    type: 'success';
    value: T;
};
declare type ResultError<E> = {
    type: 'error';
    error: {
        statusCode: E;
        statusText: string;
        apiName: string;
    };
};
export declare type IResult<T, E> = ResultSuccess<T> | ResultError<E>;
export declare function determineErrorCode(error: AxiosError | any): ErrorCodes;
declare type StartSessionResponseDto = {
    readonly draftToken: string;
    readonly loginURL: string;
};
export declare function startSession(options: {
    readonly authHost: string;
    readonly source: string;
}): StartSessionResponseDto;
declare type CheckSessionErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.loginInProgress;
export declare function checkSession(options: {
    readonly authHost: string;
    readonly draftToken: string;
}): Promise<IResult<string, CheckSessionErrorCodes>>;
export declare function getFilters(baseURL: string, source: string): Promise<IResult<ISupportedFiles, GenericErrorTypes>>;
export declare type RemoteBundle = {
    readonly bundleId: string;
    readonly missingFiles: string[];
    readonly uploadURL?: string;
};
export declare type CreateBundleErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.bigPayload | ErrorCodes.unauthorizedContent | ErrorCodes.notFound;
export declare function createBundle(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly files: IFiles;
    readonly source: string;
}): Promise<IResult<RemoteBundle, CreateBundleErrorCodes>>;
export declare type CheckBundleErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.notFound;
export declare function checkBundle(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly bundleId: string;
}): Promise<IResult<RemoteBundle, CheckBundleErrorCodes>>;
export declare type ExtendBundleErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedContent | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.bigPayload | ErrorCodes.notFound;
export declare function extendBundle(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly bundleId: string;
    readonly files: IFiles;
    readonly removedFiles?: string[];
}): Promise<IResult<RemoteBundle, ExtendBundleErrorCodes>>;
declare type CreateGitBundleErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.notFound;
export declare function createGitBundle(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly oAuthToken?: string;
    readonly username?: string;
    readonly gitUri: string;
    readonly source: string;
}, requestOptions?: RequestOptions): Promise<IResult<RemoteBundle, CreateGitBundleErrorCodes>>;
declare type UploadBundleErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedContent | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.notFound | ErrorCodes.bigPayload;
export declare function uploadFiles(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly bundleId: string;
    readonly content: IFileContent[];
}): Promise<IResult<boolean, UploadBundleErrorCodes>>;
export declare enum AnalysisStatus {
    waiting = "WAITING",
    fetching = "FETCHING",
    analyzing = "ANALYZING",
    dcDone = "DC_DONE",
    done = "DONE",
    failed = "FAILED"
}
export declare type AnalysisResponseProgress = {
    readonly status: AnalysisStatus.waiting | AnalysisStatus.fetching | AnalysisStatus.analyzing | AnalysisStatus.dcDone;
    readonly progress: number;
};
export declare type AnalysisFailedResponse = {
    readonly status: AnalysisStatus.failed;
};
export declare type AnalysisFinishedResponse = {
    readonly status: AnalysisStatus.done;
    readonly analysisURL: string;
    readonly analysisResults: IAnalysisResult;
};
export declare type GetAnalysisResponseDto = AnalysisFinishedResponse | AnalysisFailedResponse | AnalysisResponseProgress;
export declare type GetAnalysisErrorCodes = GenericErrorTypes | ErrorCodes.unauthorizedUser | ErrorCodes.unauthorizedBundleAccess | ErrorCodes.notFound;
export declare function getAnalysis(options: {
    readonly baseURL: string;
    readonly sessionToken: string;
    readonly bundleId: string;
    readonly includeLint?: boolean;
    readonly severity: number;
    readonly limitToFiles?: string[];
    readonly oAuthToken?: string;
    readonly username?: string;
    readonly source: string;
    readonly reachability?: boolean;
}, requestOptions?: RequestOptions): Promise<IResult<GetAnalysisResponseDto, GetAnalysisErrorCodes>>;
declare type ReportTelemetryRequestDto = {
    readonly baseURL: string;
    readonly sessionToken?: string;
    readonly source?: string;
    readonly type?: string;
    readonly message?: string;
    readonly path?: string;
    readonly bundleId?: string;
    readonly version?: string;
    readonly environmentVersion?: string;
    readonly data?: any;
};
export declare function reportError(options: ReportTelemetryRequestDto): Promise<IResult<void, GenericErrorTypes>>;
export declare function reportEvent(options: ReportTelemetryRequestDto): Promise<IResult<void, GenericErrorTypes>>;
export {};
