import { TSESTree, EcmaVersion, Lib } from '@typescript-eslint/types';
import { ReferencerOptions } from './referencer';
import { ScopeManager } from './ScopeManager';
interface AnalyzeOptions {
    /**
     * Known visitor keys.
     */
    childVisitorKeys?: ReferencerOptions['childVisitorKeys'];
    /**
     * Which ECMAScript version is considered.
     * Defaults to `2018`.
     */
    ecmaVersion?: EcmaVersion;
    /**
     * Whether the whole script is executed under node.js environment.
     * When enabled, the scope manager adds a function scope immediately following the global scope.
     * Defaults to `false`.
     */
    globalReturn?: boolean;
    /**
     * Implied strict mode (if ecmaVersion >= 5).
     * Defaults to `false`.
     */
    impliedStrict?: boolean;
    /**
     * The lib used by the project.
     * This automatically defines a type variable for any types provided by the configured TS libs.
     * Defaults to the lib for the provided `ecmaVersion`.
     *
     * https://www.typescriptlang.org/tsconfig#lib
     */
    lib?: Lib[];
    /**
     * The source type of the script.
     */
    sourceType?: 'script' | 'module';
}
/**
 * Takes an AST and returns the analyzed scopes.
 */
declare function analyze(tree: TSESTree.Node, providedOptions?: AnalyzeOptions): ScopeManager;
export { analyze, AnalyzeOptions };
//# sourceMappingURL=analyze.d.ts.map