"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyze = void 0;
const visitor_keys_1 = require("@typescript-eslint/visitor-keys");
const referencer_1 = require("./referencer");
const ScopeManager_1 = require("./ScopeManager");
const DEFAULT_OPTIONS = {
    childVisitorKeys: visitor_keys_1.visitorKeys,
    ecmaVersion: 2018,
    globalReturn: false,
    impliedStrict: false,
    lib: ['es2018'],
    sourceType: 'script',
};
function mapEcmaVersion(version) {
    if (version == null || version === 3 || version === 5) {
        return 'es5';
    }
    if (version > 2000) {
        return `es${version}`;
    }
    const year = 2015 + (version - 6);
    return `es${year}`;
}
/**
 * Takes an AST and returns the analyzed scopes.
 */
function analyze(tree, providedOptions) {
    var _a, _b, _c, _d, _e, _f;
    const ecmaVersion = (_a = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.ecmaVersion) !== null && _a !== void 0 ? _a : DEFAULT_OPTIONS.ecmaVersion;
    const options = {
        globalReturn: (_b = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.globalReturn) !== null && _b !== void 0 ? _b : DEFAULT_OPTIONS.globalReturn,
        impliedStrict: (_c = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.impliedStrict) !== null && _c !== void 0 ? _c : DEFAULT_OPTIONS.impliedStrict,
        sourceType: (_d = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.sourceType) !== null && _d !== void 0 ? _d : DEFAULT_OPTIONS.sourceType,
        ecmaVersion,
        childVisitorKeys: (_e = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.childVisitorKeys) !== null && _e !== void 0 ? _e : DEFAULT_OPTIONS.childVisitorKeys,
        lib: (_f = providedOptions === null || providedOptions === void 0 ? void 0 : providedOptions.lib) !== null && _f !== void 0 ? _f : [mapEcmaVersion(ecmaVersion)],
    };
    // ensure the option is lower cased
    options.lib = options.lib.map(l => l.toLowerCase());
    const scopeManager = new ScopeManager_1.ScopeManager(options);
    const referencer = new referencer_1.Referencer(options, scopeManager);
    referencer.visit(tree);
    return scopeManager;
}
exports.analyze = analyze;
//# sourceMappingURL=analyze.js.map