"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableErrorOutputSuppression = enableErrorOutputSuppression;

var _filterConsole = _interopRequireDefault(require("filter-console"));

function enableErrorOutputSuppression() {
  // Automatically registers console error suppression and restoration in supported testing frameworks
  if (typeof beforeEach === 'function' && typeof afterEach === 'function' && !process.env.RHTL_DISABLE_ERROR_FILTERING) {
    let restoreConsole;
    beforeEach(() => {
      restoreConsole = (0, _filterConsole.default)([/^The above error occurred in the <TestComponent> component:/, // error boundary output
      /^Error: Uncaught .+/ // jsdom output
      ], {
        methods: ['error']
      });
    });
    afterEach(() => restoreConsole == null ? void 0 : restoreConsole());
  }
}