# React Github and GHE Login

React component for [GitHub login](https://developer.github.com/v3/oauth/).

Extension of [react-github-login](https://github.com/checkr/react-github-login) with option for host to support Github Enterprise.

## Usage

```js
import React from 'react';
import ReactDOM from 'react-dom';
import GitHubLogin from 'react-github-login';

const onSuccess = response => console.log(response);
const onFailure = response => console.error(response);

ReactDOM.render(
  <GitHubLogin clientId="my-github-client-id"
    onSuccess={onSuccess}
    onFailure={onFailure}
    host="https://my-git-enterprise.com"
  />,
  document.getElementById('example')
);
```

### Props

#### `clientId`

`{string}` _required_

Client ID for GitHub OAuth application.

#### `redirectUri`

`{string}`

Registered redirect URI for GitHub OAuth application.

#### `scope`

`{string}`

Scope for GitHub OAuth application. Defaults to `user:email`.

#### `className`

`{string}`

CSS class for the login button.

#### `buttonText`

`{string}`

Text content for the login button.

#### `onRequest`

`{function}`

Callback for every request.

#### `onSuccess`

`{function}`

Callback for successful login. An object will be passed as an argument to the callback, e.g. `{ "code": "..." }`.

#### `onFailure`

`{function}`

Callback for errors raised during login.

#### `host`

`{string}`

Host for Github login. Defaults to `https://github.com`.
Can be provided to allow login with Github Enterprise.

## Development

```sh
$ npm install
$ npm start
```

Webpack development server starts at [http://localhost:8080](http://localhost:8080), loading [example/index.html](github.com/checkr/react-facebook-login/tree/master/example/index.html).
