module.exports = {
    "parser": "babel-eslint",

    "ecmaFeatures": {
        "arrowFunctions": true,
        "blockBindings": true,
        "classes": true,
        "defaultParams": true,
        "destructuring": true,
        "forOf": true,
        "generators": false,
        "modules": true,
        "objectLiteralComputedProperties": true,
        "objectLiteralDuplicateProperties": false,
        "objectLiteralShorthandMethods": true,
        "objectLiteralShorthandProperties": true,
        "spread": true,
        "superInFunctions": true,
        "templateStrings": true,
        "jsx": true
    },

    "plugins": [
        "react"
    ],

    "rules": {
        /**
         * Possible Errors
         */
        "comma-dangle": [1, "never"],
        "no-cond-assign": [2, "except-parens"],
        "no-console": 0,
        "no-constant-condition": 2,
        "no-control-regex": 1,
        "no-debugger": 0,
        "no-dupe-args": 2,
        "no-dupe-keys": 2,
        "no-duplicate-case": 2,
        "no-empty-character-class": 2,
        "no-empty": 2,
        "no-ex-assign": 2,
        "no-extra-boolean-cast": 2,
        "no-extra-parens": 0,
        "no-extra-semi": 2,
        "no-func-assign": 1,
        "no-inner-declarations": 0,
        "no-invalid-regexp": 2,
        "no-irregular-whitespace": 2,
        "no-negated-in-lhs": 2,
        "no-obj-calls": 2,
        "no-regex-spaces": 2,
        "no-sparse-arrays": 0,
        "no-unreachable": 0,
        "use-isnan": 2,
        "valid-jsdoc": 0,
        "valid-typeof": 0,
        "no-unexpected-multiline": 2,

        /**
         * Best Practices
         */
        "accessor-pairs": 2,
        "block-scoped-var": 1,
        "complexity": 0,
        "consistent-return": 0,
        "curly": [2, "multi-line"],
        "default-case": 0,
        "dot-notation": 0,
        "dot-location": 0,
        "eqeqeq": [2, "allow-null"],
        "guard-for-in": 0,
        "no-alert": 2,
        "no-caller": 2,
        "no-div-regex": 2,
        "no-else-return": 0,
        "no-labels": 2,
        "no-eq-null": 0,
        "no-eval": 1,
        "no-extend-native": 2,
        "no-extra-bind": 1,
        "no-fallthrough": 0,
        "no-floating-decimal": 2,
        "no-implicit-coercion": 0,
        "no-implied-eval": 2,
        "no-invalid-this": 0,
        "no-iterator": 2,
        "no-labels": 2,
        "no-lone-blocks": 2,
        "no-loop-func": 2,
        "no-multi-spaces": 2,
        "no-multi-str": 2,
        "no-native-reassign": 2,
        "no-new-func": 2,
        "no-new-wrappers": 1,
        "no-new": 2,
        "no-octal-escape": 2,
        "no-octal": 2,
        "no-param-reassign": 0,
        "no-process-env": 0,
        "no-proto": 2,
        "no-redeclare": 2,
        "no-return-assign": 2,
        "no-script-url": 2,
        "no-self-compare": 2,
        "no-sequences": 2,
        "no-throw-literal": 2,
        "no-unused-expressions": 2,
        "no-useless-call": 1,
        "no-void": 2,
        "no-warning-comments": 0,
        "no-with": 2,
        "radix": 2,
        "vars-on-top": 0,
        "wrap-iife": [2, "any"],
        "yoda": [1, "never"],

        /**
         * Strict Mode
         */
        "strict": 0,

        /**
         * Variables
         */
        "init-declarations": 0,
        "no-catch-shadow": 0,
        "no-delete-var": 2,
        "no-label-var": 2,
        "no-shadow-restricted-names": 2,
        "no-shadow": 0,
        "no-undef-init": 2,
        "no-undef": 2,
        "no-undefined": 0,
        "no-unused-vars": [2, {"vars": "all", "args": "none", "varsIgnorePattern": "^React$"}],
        "no-use-before-define": [2, "nofunc"],

        /**
         * Node.js
         */
        "callback-return": 0,
        "handle-callback-err": 0,
        "no-mixed-requires": 1,
        "no-new-require": 2,
        "no-path-concat": 2,
        "no-process-exit": 0,
        "no-restricted-modules": 0,
        "no-sync": 0,

        /**
         * Stylistic Issues
         */
        "array-bracket-spacing": [2, "never"],
        "brace-style": [2, "1tbs", { "allowSingleLine": true }],
        "camelcase": [2, {"properties": "never"}],
        "comma-spacing": 2,
        "comma-style": 2,
        "computed-property-spacing": [2, "never"],
        "consistent-this": [2, "self"],
        "eol-last": 2,
        "func-names": 0,
        "func-style": 0,
        "id-length": 0,
        "id-match": 0,
        "indent": [2, 4, {"SwitchCase": 1}],
        "jsx-quotes": [2, "prefer-double"],
        "key-spacing": 2,
        "lines-around-comment": 0,
        "linebreak-style": 0,
        "max-nested-callbacks": [2, 3],
        "new-cap": 2,
        "new-parens": 2,
        "newline-after-var": 0,
        "no-array-constructor": 2,
        "no-continue": 0,
        "no-inline-comments": 0,
        "no-lonely-if": 2,
        "no-mixed-spaces-and-tabs": [2, "smart-tabs"],
        "no-multiple-empty-lines": 2,
        "no-nested-ternary": 2,
        "no-new-object": 2,
        "no-spaced-func": 2,
        "no-ternary": 0,
        "no-trailing-spaces": 2,
        "no-underscore-dangle": 0,
        "no-unneeded-ternary": 1,
        "object-curly-spacing": [2, "always"],
        "one-var": [2, {
            "initialized": "never"
        }],
        "operator-assignment": 0,
        "operator-linebreak": [2, "after"],
        "padded-blocks": [2, "never"],
        "quote-props": [2, "consistent-as-needed"],
        "quotes": 0,
        "semi-spacing": 2,
        "semi": 2,
        "sort-vars": 0,
        "keyword-spacing": 2,
        "space-before-blocks": 2,
        "space-before-function-paren": 2,
        "space-in-parens": 2,
        "space-infix-ops": 2,
        "space-unary-ops": 2,
        "spaced-comment": 0,
        "wrap-regex": 0,

        /**
         * ECMAScript 6
         */
        "arrow-parens": 0,
        "arrow-spacing": 2,
        "constructor-super": 2,
        "generator-star-spacing": 2,
        "no-class-assign": 0,
        "no-const-assign": 2,
        "no-this-before-super": 2,
        "no-var": 0,
        "object-shorthand": 0,
        "prefer-const": 0,
        "prefer-spread": 2,
        "prefer-reflect": 2,
        "require-yield": 1,

        /**
         * Legacy
         */
        "max-depth": [1, 3],
        "max-params": [1, 5],
        "max-len": [1, 120, 4, {"ignoreComments": true, "ignoreUrls": true}],
        "max-statements": 0,
        "no-bitwise": 0,
        "no-plusplus": 0,

        /**
         * React plugin
         */
        "react/display-name": 0,
        "react/forbid-prop-types": [2, {"forbid": ["any"]}],
        "react/jsx-boolean-value": 2,
        "react/jsx-closing-bracket-location": 0,
        "react/jsx-curly-spacing": [2, "never"],
        "react/jsx-indent-props": 0,
        "react/jsx-max-props-per-line": 0,
        "react/jsx-no-duplicate-props": 2,
        "react/jsx-no-literals": 0,
        "react/jsx-no-undef": 2,
        "react/jsx-quotes": 0,
        "react/jsx-sort-prop-types": 0,
        "react/jsx-sort-props": 0,
        "react/jsx-uses-react": 0,
        "react/jsx-uses-vars": 2,
        "react/no-danger": 0,
        "react/no-did-mount-set-state": 0,
        "react/no-did-update-set-state": 2,
        "react/no-direct-mutation-state": 2,
        "react/no-multi-comp": 0,
        "react/no-set-state": 0,
        "react/no-unknown-property": 2,
        "react/prop-types": 1,
        "react/react-in-jsx-scope": 2,
        "react/require-extension": 0,
        "react/self-closing-comp": 2,
        "react/jsx-wrap-multilines": 2,
        "react/sort-comp": [2, {
            "order": [
		"mixins",
		"displayName",
		"propTypes",
		"defaultProps",
                "constructor",
		"getDefaultProps",
		"getInitialState",
		"getChildContext",
                "componentWillMount",
                "componentDidMount",
                "componentWillReceiveProps",
                "shouldComponentUpdate",
                "componentWillUpdate",
                "componentDidUpdate",
                "componentWillUnmount",
                // "/^component.+$/",
                "everything-else",
                "render"
            ]
        }]
    }
};
