/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/tektoncd/operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TektonInstallerSetsGetter has a method to return a TektonInstallerSetInterface.
// A group's client should implement this interface.
type TektonInstallerSetsGetter interface {
	TektonInstallerSets() TektonInstallerSetInterface
}

// TektonInstallerSetInterface has methods to work with TektonInstallerSet resources.
type TektonInstallerSetInterface interface {
	Create(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.CreateOptions) (*v1alpha1.TektonInstallerSet, error)
	Update(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.UpdateOptions) (*v1alpha1.TektonInstallerSet, error)
	UpdateStatus(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.UpdateOptions) (*v1alpha1.TektonInstallerSet, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TektonInstallerSet, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TektonInstallerSetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonInstallerSet, err error)
	TektonInstallerSetExpansion
}

// tektonInstallerSets implements TektonInstallerSetInterface
type tektonInstallerSets struct {
	client rest.Interface
}

// newTektonInstallerSets returns a TektonInstallerSets
func newTektonInstallerSets(c *OperatorV1alpha1Client) *tektonInstallerSets {
	return &tektonInstallerSets{
		client: c.RESTClient(),
	}
}

// Get takes name of the tektonInstallerSet, and returns the corresponding tektonInstallerSet object, and an error if there is any.
func (c *tektonInstallerSets) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonInstallerSet, err error) {
	result = &v1alpha1.TektonInstallerSet{}
	err = c.client.Get().
		Resource("tektoninstallersets").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TektonInstallerSets that match those selectors.
func (c *tektonInstallerSets) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonInstallerSetList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.TektonInstallerSetList{}
	err = c.client.Get().
		Resource("tektoninstallersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tektonInstallerSets.
func (c *tektonInstallerSets) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("tektoninstallersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tektonInstallerSet and creates it.  Returns the server's representation of the tektonInstallerSet, and an error, if there is any.
func (c *tektonInstallerSets) Create(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.CreateOptions) (result *v1alpha1.TektonInstallerSet, err error) {
	result = &v1alpha1.TektonInstallerSet{}
	err = c.client.Post().
		Resource("tektoninstallersets").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonInstallerSet).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tektonInstallerSet and updates it. Returns the server's representation of the tektonInstallerSet, and an error, if there is any.
func (c *tektonInstallerSets) Update(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.UpdateOptions) (result *v1alpha1.TektonInstallerSet, err error) {
	result = &v1alpha1.TektonInstallerSet{}
	err = c.client.Put().
		Resource("tektoninstallersets").
		Name(tektonInstallerSet.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonInstallerSet).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tektonInstallerSets) UpdateStatus(ctx context.Context, tektonInstallerSet *v1alpha1.TektonInstallerSet, opts v1.UpdateOptions) (result *v1alpha1.TektonInstallerSet, err error) {
	result = &v1alpha1.TektonInstallerSet{}
	err = c.client.Put().
		Resource("tektoninstallersets").
		Name(tektonInstallerSet.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonInstallerSet).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tektonInstallerSet and deletes it. Returns an error if one occurs.
func (c *tektonInstallerSets) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("tektoninstallersets").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tektonInstallerSets) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("tektoninstallersets").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tektonInstallerSet.
func (c *tektonInstallerSets) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonInstallerSet, err error) {
	result = &v1alpha1.TektonInstallerSet{}
	err = c.client.Patch(pt).
		Resource("tektoninstallersets").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
