/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/tektoncd/operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TektonAddonsGetter has a method to return a TektonAddonInterface.
// A group's client should implement this interface.
type TektonAddonsGetter interface {
	TektonAddons() TektonAddonInterface
}

// TektonAddonInterface has methods to work with TektonAddon resources.
type TektonAddonInterface interface {
	Create(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.CreateOptions) (*v1alpha1.TektonAddon, error)
	Update(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.UpdateOptions) (*v1alpha1.TektonAddon, error)
	UpdateStatus(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.UpdateOptions) (*v1alpha1.TektonAddon, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TektonAddon, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TektonAddonList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonAddon, err error)
	TektonAddonExpansion
}

// tektonAddons implements TektonAddonInterface
type tektonAddons struct {
	client rest.Interface
}

// newTektonAddons returns a TektonAddons
func newTektonAddons(c *OperatorV1alpha1Client) *tektonAddons {
	return &tektonAddons{
		client: c.RESTClient(),
	}
}

// Get takes name of the tektonAddon, and returns the corresponding tektonAddon object, and an error if there is any.
func (c *tektonAddons) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonAddon, err error) {
	result = &v1alpha1.TektonAddon{}
	err = c.client.Get().
		Resource("tektonaddons").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TektonAddons that match those selectors.
func (c *tektonAddons) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonAddonList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.TektonAddonList{}
	err = c.client.Get().
		Resource("tektonaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tektonAddons.
func (c *tektonAddons) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("tektonaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tektonAddon and creates it.  Returns the server's representation of the tektonAddon, and an error, if there is any.
func (c *tektonAddons) Create(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.CreateOptions) (result *v1alpha1.TektonAddon, err error) {
	result = &v1alpha1.TektonAddon{}
	err = c.client.Post().
		Resource("tektonaddons").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonAddon).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tektonAddon and updates it. Returns the server's representation of the tektonAddon, and an error, if there is any.
func (c *tektonAddons) Update(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.UpdateOptions) (result *v1alpha1.TektonAddon, err error) {
	result = &v1alpha1.TektonAddon{}
	err = c.client.Put().
		Resource("tektonaddons").
		Name(tektonAddon.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonAddon).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tektonAddons) UpdateStatus(ctx context.Context, tektonAddon *v1alpha1.TektonAddon, opts v1.UpdateOptions) (result *v1alpha1.TektonAddon, err error) {
	result = &v1alpha1.TektonAddon{}
	err = c.client.Put().
		Resource("tektonaddons").
		Name(tektonAddon.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonAddon).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tektonAddon and deletes it. Returns an error if one occurs.
func (c *tektonAddons) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("tektonaddons").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tektonAddons) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("tektonaddons").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tektonAddon.
func (c *tektonAddons) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonAddon, err error) {
	result = &v1alpha1.TektonAddon{}
	err = c.client.Patch(pt).
		Resource("tektonaddons").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
