/*
Copyright 2022 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha1

import (
	"context"
	"os"
)

func (th *TektonHub) SetDefaults(ctx context.Context) {

	if th.Spec.Db.DbSecretName == "" {
		th.Spec.Db.DbSecretName = "tekton-hub-db"
	}

	if th.Spec.Api.ApiSecretName == "" {
		th.Spec.Api.ApiSecretName = "tekton-hub-api"
	}

	if th.Spec.CommonSpec.TargetNamespace == "" {
		th.Spec.CommonSpec.TargetNamespace = os.Getenv("DEFAULT_TARGET_NAMESPACE")
	}

}
