/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTektonChains implements TektonChainInterface
type FakeTektonChains struct {
	Fake *FakeOperatorV1alpha1
}

var tektonchainsResource = schema.GroupVersionResource{Group: "operator.tekton.dev", Version: "v1alpha1", Resource: "tektonchains"}

var tektonchainsKind = schema.GroupVersionKind{Group: "operator.tekton.dev", Version: "v1alpha1", Kind: "TektonChain"}

// Get takes name of the tektonChain, and returns the corresponding tektonChain object, and an error if there is any.
func (c *FakeTektonChains) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonChain, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(tektonchainsResource, name), &v1alpha1.TektonChain{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonChain), err
}

// List takes label and field selectors, and returns the list of TektonChains that match those selectors.
func (c *FakeTektonChains) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonChainList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(tektonchainsResource, tektonchainsKind, opts), &v1alpha1.TektonChainList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.TektonChainList{ListMeta: obj.(*v1alpha1.TektonChainList).ListMeta}
	for _, item := range obj.(*v1alpha1.TektonChainList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested tektonChains.
func (c *FakeTektonChains) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(tektonchainsResource, opts))
}

// Create takes the representation of a tektonChain and creates it.  Returns the server's representation of the tektonChain, and an error, if there is any.
func (c *FakeTektonChains) Create(ctx context.Context, tektonChain *v1alpha1.TektonChain, opts v1.CreateOptions) (result *v1alpha1.TektonChain, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(tektonchainsResource, tektonChain), &v1alpha1.TektonChain{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonChain), err
}

// Update takes the representation of a tektonChain and updates it. Returns the server's representation of the tektonChain, and an error, if there is any.
func (c *FakeTektonChains) Update(ctx context.Context, tektonChain *v1alpha1.TektonChain, opts v1.UpdateOptions) (result *v1alpha1.TektonChain, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(tektonchainsResource, tektonChain), &v1alpha1.TektonChain{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonChain), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTektonChains) UpdateStatus(ctx context.Context, tektonChain *v1alpha1.TektonChain, opts v1.UpdateOptions) (*v1alpha1.TektonChain, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(tektonchainsResource, "status", tektonChain), &v1alpha1.TektonChain{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonChain), err
}

// Delete takes name of the tektonChain and deletes it. Returns an error if one occurs.
func (c *FakeTektonChains) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(tektonchainsResource, name), &v1alpha1.TektonChain{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTektonChains) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(tektonchainsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.TektonChainList{})
	return err
}

// Patch applies the patch and returns the patched tektonChain.
func (c *FakeTektonChains) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonChain, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(tektonchainsResource, name, pt, data, subresources...), &v1alpha1.TektonChain{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.TektonChain), err
}
