<!--
---
linkTitle: "TriggerTemplates"
weight: 3
---
-->
# `TriggerTemplates`

A `TriggerTemplate` is a resource that specifies a blueprint for the resource, such as a `TaskRun` or `PipelineRun`, that you want to instantiate
and/or execute when your `EventListener` detects an event. It exposes parameters that you can use anywhere within your resource's template.

`TriggerTemplates` currently support the following [Tekton Pipelines](https://github.com/tektoncd/pipeline) resources:

 `v1alpha1 `         | `v1beta1`
---------------------|---------
  `Pipeline`         | `Pipeline`
  `PipelineRun`      | `PipelineRun`
  `Task`             | `Task`
  `TaskRun`          | `TaskRun`
  `ClusterTask`      | `ClusterTask`
  `Condition`        |
  `PipelineResource` |

## Structure of a `TriggerTemplate`

Below is an example `TriggerTemplate` definition:

<!-- FILE: examples/v1beta1/triggertemplates/triggertemplate.yaml -->
```YAML
apiVersion: triggers.tekton.dev/v1beta1
kind: TriggerTemplate
metadata:
  name: pipeline-template
spec:
  params:
  - name: gitrevision
    description: The git revision
    default: main
  - name: gitrepositoryurl
    description: The git repository url
  - name: message
    description: The message to print
    default: This is the default message
  - name: contenttype
    description: The Content-Type of the event
  resourcetemplates:
  - apiVersion: tekton.dev/v1beta1
    kind: PipelineRun
    metadata:
      generateName: simple-pipeline-run-
    spec:
      pipelineRef:
        name: simple-pipeline
      params:
      - name: message
        value: $(tt.params.message)
      - name: contenttype
        value: $(tt.params.contenttype)
      resources:
      - name: git-source
        resourceSpec:
          type: git
          params:
          - name: revision
            value: $(tt.params.gitrevision)
          - name: url
            value: $(tt.params.gitrepositoryurl)
```

Keep the following in mind:

* If you don't specify the namespace, Tekton resolves it to the namespace of the `EventListener` that specifies the given `TriggerTemplate`.

* The `$(uid)` variable is implicitly available to the resource templates you specify in your `TriggerTemplate` with a random value, just like
  the postfix generated by the Kubernetes `generateName` metadata field. This can be useful for resource templates that use internal references.

* Tekton adds the following labels to all resource templates within a `TriggerTemplate`:

  * `tekton.dev/eventlistenter`:`<EventListenerName>` to help with housekeeping and garbage collection.
  * `tekton.dev/triggers-eventid`:`<EventID>` to track resources created by a specific event.

* To support arbitrary resource types, Tekton resolves resource templates internally as byte blobs. Because of this, Tekton only validates these
  resources when processing an event rather than at the creation of the `TriggerTemplate`. Thus, you can **only** specify Tekton resources in a
  `TriggerTemplate`.

* As of Tekton Pipelines [0.8.0](https://github.com/tektoncd/pipeline/releases/tag/v0.8.0), you can embed resource definitions directly in
  your `TriggerTemplate` definition. To prevent a race condition between creating and using resources, you **must** embed each resource definition
  within the `PipelineRun` or `TaskRun` that uses that resource.

## Specifying parameters

A `TriggerTemplate` allows you to declare parameters supplied by the associated `TriggerBinding` and/or `EventListener` as follows:

* Declare your parameters in the `params` section of the `TriggerTemplate` definition.

* You must specify a `name` and can optionally specify a `description` and a `default` value.

* Tekton applies the value of the `default` field for each entry in the `params` array of your `TriggerTemplate` if it can't find a corresponding
  value in the associated `TriggerBinding` or cannot successfully extract the value from an HTTP header or body payload.

* You can reference `tt.params` in the `resourcetemplates` section of your `TriggerTemplate` to make your `TriggerTemplate` reusable.

* When you specify parameters in your resource template definitions, Tekton replaces the specified string with the parameter name, for example `$(tt.params.name)`.
  Therefore, simple string and number value replacements work fine directly in your YAML file. However, if a string has a numerical prefix, such as `123abcd`,
  Tekton can misinterpret it to be a number and throw an error. In such cases, enclose the affected parameter key in quotes (`"`).


## Embedding JSON objects within resource templates

Tekton no longer replaces quotes (`"`) with escaped quotes (`\"`) and does not perform any escaping on variables in your resource templates.
If you are embedding JSON objects as variables in your templates, you **must not** enclose them with quotes (`"`). If you have existing `TriggerTemplates`
that use escaped quotes, add an annotation to work around this behavior change.

For example, consider the following JSON object:

```json
{
  "title": "this is \"demo\" body",
  "object": {
    "name": "testing"
  }
}
```

If your `TriggerBinding` extracts `$(body.title)` then Tekton inserts it into your `TriggerTemplate` as `this is a \"demo\" body`.
To work around this, annotate the `TriggerTemplate` as follows:

```yaml
apiVersion: triggers.tekton.dev/v1alpha1
kind: TriggerTemplate
metadata:
  name: escaped-tt
  annotations:
    triggers.tekton.dev/old-escape-quotes: "true"
spec:
  params:
  - name: title
    description: The title from the incoming body
```

This way, Tekton passes the value as `this is a \""demo\"" body`, which in itself is not valid JSON code; however, if you use a value with `$(body.object)`
in a resource template that specifically passes it as a quoted string, then this workaround restores normal operation. This can also be useful for parsing
a string containing JSON code in a command.
