# Weekly VPNKit dev report for 2017-05-29 to 2017-06-04 (week 22)

This report covers weekly developments in the [vpnkit] and associated libraries ([mirage/ocaml-dns] [mirage/ocaml-hvsock] [dnssd] [tcpip] [ocaml-uri] [ocaml-ipaddr] [ocaml-uri]). These form the basis of the VPNKit toolkit used to translate container network traffic into native platform socket calls on Windows and OSX.

This week mostly saw stabilisation of the transparent HTTP proxy feature in VPNKit, which has now been integrated downstream into Docker for Desktop.
There is documentation on how to try it in the tree ([vpnkit#231] [@djs55]).  Since this Moby component now includes HTTP functionality, these reports also report on the additional MirageOS libraries used in this part of the stack (such as [mirage/ocaml-cohttp]).

Tests were added to check file description limits ([vpnkit#228] [@djs55]) and also edge cases when the connection limits are hit ([vpnkit#229] [@djs55]).  The logging ease of debugging of the tests were also improved ([vpnkit#230] [@djs55]).
In general, testing of weird network connections remains an area where VPNKit needs help -- for example see this about unreliable wifi ([vpnkit#227] [@djs55]).

In the DNS library, there have been a slew of releases to port the build to the faster [Jbuilder](http://ocamllabs.io/events/2017/05/26/JbuilderDemo.html) ([ocaml-uri#104] [ocaml-uri#105] [@dsheets] [ocaml-ipaddr#64] [ocaml-ipaddr#65] [@avsm]).
Some examples were added to the repository to show how to build static DNS services ([mirage/ocaml-dns#138] [@avsm @djs55]).  There will be minor releases of the Uri, Ipaddr and DNS libraries this week with these changes ([ocaml-uri:v1.9.4] [ocaml-ipaddr:2.8.0])

In the TCP/IP library, there is a long-running PR to support IP fragmentation ([tcpip#243] [@samoht]). Although it has been closed due to conflicting with the current master branch, this is a good time to figure out how the IP layer should signal "dont fragment" up the stack, so that Path MTU discovery can also be implementation.  We also restored some pre-2012 history to the TCP/IP library that had been lost in some Git rearrangements a few years ago, so you will need to rebase any outstanding PRs to the library ([[tcpip#270]).

In the Cohttp library, there is a large effort by [@rgrinberg] to port it to Jbuilder and smaller subcomponents.  The `mirage-http` library that was formerly a separate component has now been merged directly back into Cohttp as part of this refactoring, in order to simplify the number of repositories we have to deal with ([mirage/ocaml-cohttp#550] [@rgrinberg]).

Other reports in this series can be browsed directly in the repository at [vpnkit:/reports](https://github.com/moby/vpnkit/tree/master/reports/).

[@avsm]: https://github.com/avsm
[@djs55]: https://github.com/djs55
[@dsheets]: https://github.com/dsheets
[@hannesm]: https://github.com/hannesm
[@hcarty]: https://github.com/hcarty
[@rgrinberg]: https://github.com/rgrinberg
[@samoht]: https://github.com/samoht
[dnssd]: https://github.com/djs55/ocaml-osx-dnssd
[tcpip]: https://github.com/mirage/mirage-tcpip
[tcpip#202]: https://github.com/mirage/mirage-tcpip/pull/202
[tcpip#243]: https://github.com/mirage/mirage-tcpip/pull/243
[tcpip#270]: https://github.com/mirage/mirage-tcpip/issues/270
[mirage/ocaml-cohttp]: https://github.com/mirage/ocaml-cohttp
[mirage/ocaml-cohttp#550]: https://github.com/mirage/ocaml-cohttp/pull/550
[mirage/ocaml-cohttp#551]: https://github.com/mirage/ocaml-cohttp/pull/551
[mirage/ocaml-dns]: https://github.com/mirage/ocaml-dns
[mirage/ocaml-dns#138]: https://github.com/mirage/ocaml-dns/pull/138
[mirage/ocaml-dns#142]: https://github.com/mirage/ocaml-dns/pull/142
[mirage/ocaml-hvsock]: https://github.com/mirage/ocaml-hvsock
[ocaml-ipaddr]: https://github.com/mirage/ocaml-ipaddr
[ocaml-ipaddr#64]: https://github.com/mirage/ocaml-ipaddr/pull/64
[ocaml-ipaddr#65]: https://github.com/mirage/ocaml-ipaddr/pull/65
[ocaml-ipaddr:2.8.0]: https://github.com/mirage/ocaml-ipaddr/releases/tag/2.8.0
[ocaml-uri]: https://github.com/mirage/ocaml-uri
[ocaml-uri#104]: https://github.com/mirage/ocaml-uri/pull/104
[ocaml-uri#105]: https://github.com/mirage/ocaml-uri/pull/105
[ocaml-uri#97]: https://github.com/mirage/ocaml-uri/pull/97
[ocaml-uri:v1.9.4]: https://github.com/mirage/ocaml-uri/releases/tag/v1.9.4
[vpnkit]: https://github.com/moby/vpnkit
[vpnkit#219]: https://github.com/moby/vpnkit/pull/219
[vpnkit#227]: https://github.com/moby/vpnkit/issues/227
[vpnkit#228]: https://github.com/moby/vpnkit/pull/228
[vpnkit#229]: https://github.com/moby/vpnkit/pull/229
[vpnkit#230]: https://github.com/moby/vpnkit/pull/230
[vpnkit#231]: https://github.com/moby/vpnkit/pull/231

