// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateCreatedArtifact = "AssociateCreatedArtifact"

// AssociateCreatedArtifactRequest generates a "aws/request.Request" representing the
// client's request for the AssociateCreatedArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateCreatedArtifact for more information on using the AssociateCreatedArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateCreatedArtifactRequest method.
//    req, resp := client.AssociateCreatedArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateCreatedArtifact
func (c *MigrationHub) AssociateCreatedArtifactRequest(input *AssociateCreatedArtifactInput) (req *request.Request, output *AssociateCreatedArtifactOutput) {
	op := &request.Operation{
		Name:       opAssociateCreatedArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateCreatedArtifactInput{}
	}

	output = &AssociateCreatedArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateCreatedArtifact API operation for AWS Migration Hub.
//
// Associates a created artifact of an AWS cloud resource, the target receiving
// the migration, with the migration task performed by a migration tool. This
// API has the following traits:
//
//    * Migration tools can call the AssociateCreatedArtifact operation to indicate
//    which AWS artifact is associated with a migration task.
//
//    * The created artifact name must be provided in ARN (Amazon Resource Name)
//    format which will contain information about type and region; for example:
//    arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b.
//
//    * Examples of the AWS resource behind the created artifact are, AMI's,
//    EC2 instance, or DMS endpoint, etc.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation AssociateCreatedArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateCreatedArtifact
func (c *MigrationHub) AssociateCreatedArtifact(input *AssociateCreatedArtifactInput) (*AssociateCreatedArtifactOutput, error) {
	req, out := c.AssociateCreatedArtifactRequest(input)
	return out, req.Send()
}

// AssociateCreatedArtifactWithContext is the same as AssociateCreatedArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateCreatedArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) AssociateCreatedArtifactWithContext(ctx aws.Context, input *AssociateCreatedArtifactInput, opts ...request.Option) (*AssociateCreatedArtifactOutput, error) {
	req, out := c.AssociateCreatedArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDiscoveredResource = "AssociateDiscoveredResource"

// AssociateDiscoveredResourceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDiscoveredResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDiscoveredResource for more information on using the AssociateDiscoveredResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDiscoveredResourceRequest method.
//    req, resp := client.AssociateDiscoveredResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateDiscoveredResource
func (c *MigrationHub) AssociateDiscoveredResourceRequest(input *AssociateDiscoveredResourceInput) (req *request.Request, output *AssociateDiscoveredResourceOutput) {
	op := &request.Operation{
		Name:       opAssociateDiscoveredResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDiscoveredResourceInput{}
	}

	output = &AssociateDiscoveredResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateDiscoveredResource API operation for AWS Migration Hub.
//
// Associates a discovered resource ID from Application Discovery Service (ADS)
// with a migration task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation AssociateDiscoveredResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodePolicyErrorException "PolicyErrorException"
//   Exception raised when there are problems accessing ADS (Application Discovery
//   Service); most likely due to a misconfigured policy or the migrationhub-discovery
//   role is missing or not configured correctly.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/AssociateDiscoveredResource
func (c *MigrationHub) AssociateDiscoveredResource(input *AssociateDiscoveredResourceInput) (*AssociateDiscoveredResourceOutput, error) {
	req, out := c.AssociateDiscoveredResourceRequest(input)
	return out, req.Send()
}

// AssociateDiscoveredResourceWithContext is the same as AssociateDiscoveredResource with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDiscoveredResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) AssociateDiscoveredResourceWithContext(ctx aws.Context, input *AssociateDiscoveredResourceInput, opts ...request.Option) (*AssociateDiscoveredResourceOutput, error) {
	req, out := c.AssociateDiscoveredResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProgressUpdateStream = "CreateProgressUpdateStream"

// CreateProgressUpdateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateProgressUpdateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProgressUpdateStream for more information on using the CreateProgressUpdateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProgressUpdateStreamRequest method.
//    req, resp := client.CreateProgressUpdateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/CreateProgressUpdateStream
func (c *MigrationHub) CreateProgressUpdateStreamRequest(input *CreateProgressUpdateStreamInput) (req *request.Request, output *CreateProgressUpdateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateProgressUpdateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProgressUpdateStreamInput{}
	}

	output = &CreateProgressUpdateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProgressUpdateStream API operation for AWS Migration Hub.
//
// Creates a progress update stream which is an AWS resource used for access
// control as well as a namespace for migration task names that is implicitly
// linked to your AWS account. It must uniquely identify the migration tool
// as it is used for all updates made by the tool; however, it does not need
// to be unique for each AWS account because it is scoped to the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation CreateProgressUpdateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/CreateProgressUpdateStream
func (c *MigrationHub) CreateProgressUpdateStream(input *CreateProgressUpdateStreamInput) (*CreateProgressUpdateStreamOutput, error) {
	req, out := c.CreateProgressUpdateStreamRequest(input)
	return out, req.Send()
}

// CreateProgressUpdateStreamWithContext is the same as CreateProgressUpdateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProgressUpdateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) CreateProgressUpdateStreamWithContext(ctx aws.Context, input *CreateProgressUpdateStreamInput, opts ...request.Option) (*CreateProgressUpdateStreamOutput, error) {
	req, out := c.CreateProgressUpdateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProgressUpdateStream = "DeleteProgressUpdateStream"

// DeleteProgressUpdateStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProgressUpdateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProgressUpdateStream for more information on using the DeleteProgressUpdateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProgressUpdateStreamRequest method.
//    req, resp := client.DeleteProgressUpdateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStream
func (c *MigrationHub) DeleteProgressUpdateStreamRequest(input *DeleteProgressUpdateStreamInput) (req *request.Request, output *DeleteProgressUpdateStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteProgressUpdateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProgressUpdateStreamInput{}
	}

	output = &DeleteProgressUpdateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProgressUpdateStream API operation for AWS Migration Hub.
//
// Deletes a progress update stream, including all of its tasks, which was previously
// created as an AWS resource used for access control. This API has the following
// traits:
//
//    * The only parameter needed for DeleteProgressUpdateStream is the stream
//    name (same as a CreateProgressUpdateStream call).
//
//    * The call will return, and a background process will asynchronously delete
//    the stream and all of its resources (tasks, associated resources, resource
//    attributes, created artifacts).
//
//    * If the stream takes time to be deleted, it might still show up on a
//    ListProgressUpdateStreams call.
//
//    * CreateProgressUpdateStream, ImportMigrationTask, NotifyMigrationTaskState,
//    and all Associate[*] APIs realted to the tasks belonging to the stream
//    will throw "InvalidInputException" if the stream of the same name is in
//    the process of being deleted.
//
//    * Once the stream and all of its resources are deleted, CreateProgressUpdateStream
//    for a stream of the same name will succeed, and that stream will be an
//    entirely new logical resource (without any resources associated with the
//    old stream).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation DeleteProgressUpdateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStream
func (c *MigrationHub) DeleteProgressUpdateStream(input *DeleteProgressUpdateStreamInput) (*DeleteProgressUpdateStreamOutput, error) {
	req, out := c.DeleteProgressUpdateStreamRequest(input)
	return out, req.Send()
}

// DeleteProgressUpdateStreamWithContext is the same as DeleteProgressUpdateStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProgressUpdateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) DeleteProgressUpdateStreamWithContext(ctx aws.Context, input *DeleteProgressUpdateStreamInput, opts ...request.Option) (*DeleteProgressUpdateStreamOutput, error) {
	req, out := c.DeleteProgressUpdateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationState = "DescribeApplicationState"

// DescribeApplicationStateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationState for more information on using the DescribeApplicationState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationStateRequest method.
//    req, resp := client.DescribeApplicationStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeApplicationState
func (c *MigrationHub) DescribeApplicationStateRequest(input *DescribeApplicationStateInput) (req *request.Request, output *DescribeApplicationStateOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationStateInput{}
	}

	output = &DescribeApplicationStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationState API operation for AWS Migration Hub.
//
// Gets the migration status of an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation DescribeApplicationState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodePolicyErrorException "PolicyErrorException"
//   Exception raised when there are problems accessing ADS (Application Discovery
//   Service); most likely due to a misconfigured policy or the migrationhub-discovery
//   role is missing or not configured correctly.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeApplicationState
func (c *MigrationHub) DescribeApplicationState(input *DescribeApplicationStateInput) (*DescribeApplicationStateOutput, error) {
	req, out := c.DescribeApplicationStateRequest(input)
	return out, req.Send()
}

// DescribeApplicationStateWithContext is the same as DescribeApplicationState with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) DescribeApplicationStateWithContext(ctx aws.Context, input *DescribeApplicationStateInput, opts ...request.Option) (*DescribeApplicationStateOutput, error) {
	req, out := c.DescribeApplicationStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMigrationTask = "DescribeMigrationTask"

// DescribeMigrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMigrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMigrationTask for more information on using the DescribeMigrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMigrationTaskRequest method.
//    req, resp := client.DescribeMigrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeMigrationTask
func (c *MigrationHub) DescribeMigrationTaskRequest(input *DescribeMigrationTaskInput) (req *request.Request, output *DescribeMigrationTaskOutput) {
	op := &request.Operation{
		Name:       opDescribeMigrationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMigrationTaskInput{}
	}

	output = &DescribeMigrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMigrationTask API operation for AWS Migration Hub.
//
// Retrieves a list of all attributes associated with a specific migration task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation DescribeMigrationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DescribeMigrationTask
func (c *MigrationHub) DescribeMigrationTask(input *DescribeMigrationTaskInput) (*DescribeMigrationTaskOutput, error) {
	req, out := c.DescribeMigrationTaskRequest(input)
	return out, req.Send()
}

// DescribeMigrationTaskWithContext is the same as DescribeMigrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMigrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) DescribeMigrationTaskWithContext(ctx aws.Context, input *DescribeMigrationTaskInput, opts ...request.Option) (*DescribeMigrationTaskOutput, error) {
	req, out := c.DescribeMigrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateCreatedArtifact = "DisassociateCreatedArtifact"

// DisassociateCreatedArtifactRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateCreatedArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateCreatedArtifact for more information on using the DisassociateCreatedArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateCreatedArtifactRequest method.
//    req, resp := client.DisassociateCreatedArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateCreatedArtifact
func (c *MigrationHub) DisassociateCreatedArtifactRequest(input *DisassociateCreatedArtifactInput) (req *request.Request, output *DisassociateCreatedArtifactOutput) {
	op := &request.Operation{
		Name:       opDisassociateCreatedArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateCreatedArtifactInput{}
	}

	output = &DisassociateCreatedArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateCreatedArtifact API operation for AWS Migration Hub.
//
// Disassociates a created artifact of an AWS resource with a migration task
// performed by a migration tool that was previously associated. This API has
// the following traits:
//
//    * A migration user can call the DisassociateCreatedArtifacts operation
//    to disassociate a created AWS Artifact from a migration task.
//
//    * The created artifact name must be provided in ARN (Amazon Resource Name)
//    format which will contain information about type and region; for example:
//    arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b.
//
//    * Examples of the AWS resource behind the created artifact are, AMI's,
//    EC2 instance, or RDS instance, etc.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation DisassociateCreatedArtifact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateCreatedArtifact
func (c *MigrationHub) DisassociateCreatedArtifact(input *DisassociateCreatedArtifactInput) (*DisassociateCreatedArtifactOutput, error) {
	req, out := c.DisassociateCreatedArtifactRequest(input)
	return out, req.Send()
}

// DisassociateCreatedArtifactWithContext is the same as DisassociateCreatedArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateCreatedArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) DisassociateCreatedArtifactWithContext(ctx aws.Context, input *DisassociateCreatedArtifactInput, opts ...request.Option) (*DisassociateCreatedArtifactOutput, error) {
	req, out := c.DisassociateCreatedArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDiscoveredResource = "DisassociateDiscoveredResource"

// DisassociateDiscoveredResourceRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDiscoveredResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDiscoveredResource for more information on using the DisassociateDiscoveredResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDiscoveredResourceRequest method.
//    req, resp := client.DisassociateDiscoveredResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateDiscoveredResource
func (c *MigrationHub) DisassociateDiscoveredResourceRequest(input *DisassociateDiscoveredResourceInput) (req *request.Request, output *DisassociateDiscoveredResourceOutput) {
	op := &request.Operation{
		Name:       opDisassociateDiscoveredResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDiscoveredResourceInput{}
	}

	output = &DisassociateDiscoveredResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateDiscoveredResource API operation for AWS Migration Hub.
//
// Disassociate an Application Discovery Service (ADS) discovered resource from
// a migration task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation DisassociateDiscoveredResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DisassociateDiscoveredResource
func (c *MigrationHub) DisassociateDiscoveredResource(input *DisassociateDiscoveredResourceInput) (*DisassociateDiscoveredResourceOutput, error) {
	req, out := c.DisassociateDiscoveredResourceRequest(input)
	return out, req.Send()
}

// DisassociateDiscoveredResourceWithContext is the same as DisassociateDiscoveredResource with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDiscoveredResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) DisassociateDiscoveredResourceWithContext(ctx aws.Context, input *DisassociateDiscoveredResourceInput, opts ...request.Option) (*DisassociateDiscoveredResourceOutput, error) {
	req, out := c.DisassociateDiscoveredResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportMigrationTask = "ImportMigrationTask"

// ImportMigrationTaskRequest generates a "aws/request.Request" representing the
// client's request for the ImportMigrationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportMigrationTask for more information on using the ImportMigrationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportMigrationTaskRequest method.
//    req, resp := client.ImportMigrationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ImportMigrationTask
func (c *MigrationHub) ImportMigrationTaskRequest(input *ImportMigrationTaskInput) (req *request.Request, output *ImportMigrationTaskOutput) {
	op := &request.Operation{
		Name:       opImportMigrationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportMigrationTaskInput{}
	}

	output = &ImportMigrationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportMigrationTask API operation for AWS Migration Hub.
//
// Registers a new migration task which represents a server, database, etc.,
// being migrated to AWS by a migration tool.
//
// This API is a prerequisite to calling the NotifyMigrationTaskState API as
// the migration tool must first register the migration task with Migration
// Hub.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation ImportMigrationTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ImportMigrationTask
func (c *MigrationHub) ImportMigrationTask(input *ImportMigrationTaskInput) (*ImportMigrationTaskOutput, error) {
	req, out := c.ImportMigrationTaskRequest(input)
	return out, req.Send()
}

// ImportMigrationTaskWithContext is the same as ImportMigrationTask with the addition of
// the ability to pass a context and additional request options.
//
// See ImportMigrationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) ImportMigrationTaskWithContext(ctx aws.Context, input *ImportMigrationTaskInput, opts ...request.Option) (*ImportMigrationTaskOutput, error) {
	req, out := c.ImportMigrationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCreatedArtifacts = "ListCreatedArtifacts"

// ListCreatedArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListCreatedArtifacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCreatedArtifacts for more information on using the ListCreatedArtifacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCreatedArtifactsRequest method.
//    req, resp := client.ListCreatedArtifactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts
func (c *MigrationHub) ListCreatedArtifactsRequest(input *ListCreatedArtifactsInput) (req *request.Request, output *ListCreatedArtifactsOutput) {
	op := &request.Operation{
		Name:       opListCreatedArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCreatedArtifactsInput{}
	}

	output = &ListCreatedArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCreatedArtifacts API operation for AWS Migration Hub.
//
// Lists the created artifacts attached to a given migration task in an update
// stream. This API has the following traits:
//
//    * Gets the list of the created artifacts while migration is taking place.
//
//    * Shows the artifacts created by the migration tool that was associated
//    by the AssociateCreatedArtifact API.
//
//    * Lists created artifacts in a paginated interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation ListCreatedArtifacts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListCreatedArtifacts
func (c *MigrationHub) ListCreatedArtifacts(input *ListCreatedArtifactsInput) (*ListCreatedArtifactsOutput, error) {
	req, out := c.ListCreatedArtifactsRequest(input)
	return out, req.Send()
}

// ListCreatedArtifactsWithContext is the same as ListCreatedArtifacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListCreatedArtifacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) ListCreatedArtifactsWithContext(ctx aws.Context, input *ListCreatedArtifactsInput, opts ...request.Option) (*ListCreatedArtifactsOutput, error) {
	req, out := c.ListCreatedArtifactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDiscoveredResources = "ListDiscoveredResources"

// ListDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveredResources for more information on using the ListDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDiscoveredResourcesRequest method.
//    req, resp := client.ListDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources
func (c *MigrationHub) ListDiscoveredResourcesRequest(input *ListDiscoveredResourcesInput) (req *request.Request, output *ListDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDiscoveredResourcesInput{}
	}

	output = &ListDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoveredResources API operation for AWS Migration Hub.
//
// Lists discovered resources associated with the given MigrationTask.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation ListDiscoveredResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListDiscoveredResources
func (c *MigrationHub) ListDiscoveredResources(input *ListDiscoveredResourcesInput) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListDiscoveredResourcesWithContext is the same as ListDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) ListDiscoveredResourcesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, opts ...request.Option) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMigrationTasks = "ListMigrationTasks"

// ListMigrationTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListMigrationTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMigrationTasks for more information on using the ListMigrationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMigrationTasksRequest method.
//    req, resp := client.ListMigrationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks
func (c *MigrationHub) ListMigrationTasksRequest(input *ListMigrationTasksInput) (req *request.Request, output *ListMigrationTasksOutput) {
	op := &request.Operation{
		Name:       opListMigrationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListMigrationTasksInput{}
	}

	output = &ListMigrationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMigrationTasks API operation for AWS Migration Hub.
//
// Lists all, or filtered by resource name, migration tasks associated with
// the user account making this call. This API has the following traits:
//
//    * Can show a summary list of the most recent migration tasks.
//
//    * Can show a summary list of migration tasks associated with a given discovered
//    resource.
//
//    * Lists migration tasks in a paginated interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation ListMigrationTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodePolicyErrorException "PolicyErrorException"
//   Exception raised when there are problems accessing ADS (Application Discovery
//   Service); most likely due to a misconfigured policy or the migrationhub-discovery
//   role is missing or not configured correctly.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListMigrationTasks
func (c *MigrationHub) ListMigrationTasks(input *ListMigrationTasksInput) (*ListMigrationTasksOutput, error) {
	req, out := c.ListMigrationTasksRequest(input)
	return out, req.Send()
}

// ListMigrationTasksWithContext is the same as ListMigrationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListMigrationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) ListMigrationTasksWithContext(ctx aws.Context, input *ListMigrationTasksInput, opts ...request.Option) (*ListMigrationTasksOutput, error) {
	req, out := c.ListMigrationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProgressUpdateStreams = "ListProgressUpdateStreams"

// ListProgressUpdateStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListProgressUpdateStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProgressUpdateStreams for more information on using the ListProgressUpdateStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProgressUpdateStreamsRequest method.
//    req, resp := client.ListProgressUpdateStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams
func (c *MigrationHub) ListProgressUpdateStreamsRequest(input *ListProgressUpdateStreamsInput) (req *request.Request, output *ListProgressUpdateStreamsOutput) {
	op := &request.Operation{
		Name:       opListProgressUpdateStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProgressUpdateStreamsInput{}
	}

	output = &ListProgressUpdateStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProgressUpdateStreams API operation for AWS Migration Hub.
//
// Lists progress update streams associated with the user account making this
// call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation ListProgressUpdateStreams for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/ListProgressUpdateStreams
func (c *MigrationHub) ListProgressUpdateStreams(input *ListProgressUpdateStreamsInput) (*ListProgressUpdateStreamsOutput, error) {
	req, out := c.ListProgressUpdateStreamsRequest(input)
	return out, req.Send()
}

// ListProgressUpdateStreamsWithContext is the same as ListProgressUpdateStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListProgressUpdateStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) ListProgressUpdateStreamsWithContext(ctx aws.Context, input *ListProgressUpdateStreamsInput, opts ...request.Option) (*ListProgressUpdateStreamsOutput, error) {
	req, out := c.ListProgressUpdateStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNotifyApplicationState = "NotifyApplicationState"

// NotifyApplicationStateRequest generates a "aws/request.Request" representing the
// client's request for the NotifyApplicationState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyApplicationState for more information on using the NotifyApplicationState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyApplicationStateRequest method.
//    req, resp := client.NotifyApplicationStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyApplicationState
func (c *MigrationHub) NotifyApplicationStateRequest(input *NotifyApplicationStateInput) (req *request.Request, output *NotifyApplicationStateOutput) {
	op := &request.Operation{
		Name:       opNotifyApplicationState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyApplicationStateInput{}
	}

	output = &NotifyApplicationStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// NotifyApplicationState API operation for AWS Migration Hub.
//
// Sets the migration state of an application. For a given application identified
// by the value passed to ApplicationId, its status is set or updated by passing
// one of three values to Status: NOT_STARTED | IN_PROGRESS | COMPLETED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation NotifyApplicationState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodePolicyErrorException "PolicyErrorException"
//   Exception raised when there are problems accessing ADS (Application Discovery
//   Service); most likely due to a misconfigured policy or the migrationhub-discovery
//   role is missing or not configured correctly.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyApplicationState
func (c *MigrationHub) NotifyApplicationState(input *NotifyApplicationStateInput) (*NotifyApplicationStateOutput, error) {
	req, out := c.NotifyApplicationStateRequest(input)
	return out, req.Send()
}

// NotifyApplicationStateWithContext is the same as NotifyApplicationState with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyApplicationState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) NotifyApplicationStateWithContext(ctx aws.Context, input *NotifyApplicationStateInput, opts ...request.Option) (*NotifyApplicationStateOutput, error) {
	req, out := c.NotifyApplicationStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNotifyMigrationTaskState = "NotifyMigrationTaskState"

// NotifyMigrationTaskStateRequest generates a "aws/request.Request" representing the
// client's request for the NotifyMigrationTaskState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyMigrationTaskState for more information on using the NotifyMigrationTaskState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyMigrationTaskStateRequest method.
//    req, resp := client.NotifyMigrationTaskStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskState
func (c *MigrationHub) NotifyMigrationTaskStateRequest(input *NotifyMigrationTaskStateInput) (req *request.Request, output *NotifyMigrationTaskStateOutput) {
	op := &request.Operation{
		Name:       opNotifyMigrationTaskState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyMigrationTaskStateInput{}
	}

	output = &NotifyMigrationTaskStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// NotifyMigrationTaskState API operation for AWS Migration Hub.
//
// Notifies Migration Hub of the current status, progress, or other detail regarding
// a migration task. This API has the following traits:
//
//    * Migration tools will call the NotifyMigrationTaskState API to share
//    the latest progress and status.
//
//    * MigrationTaskName is used for addressing updates to the correct target.
//
//    * ProgressUpdateStream is used for access control and to provide a namespace
//    for each migration tool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation NotifyMigrationTaskState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/NotifyMigrationTaskState
func (c *MigrationHub) NotifyMigrationTaskState(input *NotifyMigrationTaskStateInput) (*NotifyMigrationTaskStateOutput, error) {
	req, out := c.NotifyMigrationTaskStateRequest(input)
	return out, req.Send()
}

// NotifyMigrationTaskStateWithContext is the same as NotifyMigrationTaskState with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyMigrationTaskState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) NotifyMigrationTaskStateWithContext(ctx aws.Context, input *NotifyMigrationTaskStateInput, opts ...request.Option) (*NotifyMigrationTaskStateOutput, error) {
	req, out := c.NotifyMigrationTaskStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResourceAttributes = "PutResourceAttributes"

// PutResourceAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutResourceAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourceAttributes for more information on using the PutResourceAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutResourceAttributesRequest method.
//    req, resp := client.PutResourceAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/PutResourceAttributes
func (c *MigrationHub) PutResourceAttributesRequest(input *PutResourceAttributesInput) (req *request.Request, output *PutResourceAttributesOutput) {
	op := &request.Operation{
		Name:       opPutResourceAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourceAttributesInput{}
	}

	output = &PutResourceAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourceAttributes API operation for AWS Migration Hub.
//
// Provides identifying details of the resource being migrated so that it can
// be associated in the Application Discovery Service (ADS)'s repository. This
// association occurs asynchronously after PutResourceAttributes returns.
//
// Keep in mind that subsequent calls to PutResourceAttributes will override
// previously stored attributes. For example, if it is first called with a MAC
// address, but later, it is desired to add an IP address, it will then be required
// to call it with both the IP and MAC addresses to prevent overiding the MAC
// address.
//
// Note the instructions regarding the special use case of the ResourceAttributeList
// (https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList)
// parameter when specifying any "VM" related value.
//
// Because this is an asynchronous call, it will always return 200, whether
// an association occurs or not. To confirm if an association was found based
// on the provided details, call ListDiscoveredResources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Migration Hub's
// API operation PutResourceAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You do not have sufficient access to perform this action.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Exception raised when there is an internal, configuration, or dependency
//   error encountered.
//
//   * ErrCodeDryRunOperation "DryRunOperation"
//   Exception raised to indicate a successfully authorized action when the DryRun
//   flag is set to "true".
//
//   * ErrCodeUnauthorizedOperation "UnauthorizedOperation"
//   Exception raised to indicate a request was not authorized when the DryRun
//   flag is set to "true".
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Exception raised when the provided input violates a policy constraint or
//   is entered in the wrong format or data type.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Exception raised when the request references a resource (ADS configuration,
//   update stream, migration task, etc.) that does not exist in ADS (Application
//   Discovery Service) or in Migration Hub's repository.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/PutResourceAttributes
func (c *MigrationHub) PutResourceAttributes(input *PutResourceAttributesInput) (*PutResourceAttributesOutput, error) {
	req, out := c.PutResourceAttributesRequest(input)
	return out, req.Send()
}

// PutResourceAttributesWithContext is the same as PutResourceAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourceAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MigrationHub) PutResourceAttributesWithContext(ctx aws.Context, input *PutResourceAttributesInput, opts ...request.Option) (*PutResourceAttributesOutput, error) {
	req, out := c.PutResourceAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateCreatedArtifactInput struct {
	_ struct{} `type:"structure"`

	// An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance,
	// RDS instance, etc.)
	//
	// CreatedArtifact is a required field
	CreatedArtifact *CreatedArtifact `type:"structure" required:"true"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateCreatedArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateCreatedArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateCreatedArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateCreatedArtifactInput"}
	if s.CreatedArtifact == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatedArtifact"))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}
	if s.CreatedArtifact != nil {
		if err := s.CreatedArtifact.Validate(); err != nil {
			invalidParams.AddNested("CreatedArtifact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedArtifact sets the CreatedArtifact field's value.
func (s *AssociateCreatedArtifactInput) SetCreatedArtifact(v *CreatedArtifact) *AssociateCreatedArtifactInput {
	s.CreatedArtifact = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AssociateCreatedArtifactInput) SetDryRun(v bool) *AssociateCreatedArtifactInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *AssociateCreatedArtifactInput) SetMigrationTaskName(v string) *AssociateCreatedArtifactInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *AssociateCreatedArtifactInput) SetProgressUpdateStream(v string) *AssociateCreatedArtifactInput {
	s.ProgressUpdateStream = &v
	return s
}

type AssociateCreatedArtifactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateCreatedArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateCreatedArtifactOutput) GoString() string {
	return s.String()
}

type AssociateDiscoveredResourceInput struct {
	_ struct{} `type:"structure"`

	// Object representing a Resource.
	//
	// DiscoveredResource is a required field
	DiscoveredResource *DiscoveredResource `type:"structure" required:"true"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The identifier given to the MigrationTask.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDiscoveredResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDiscoveredResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDiscoveredResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDiscoveredResourceInput"}
	if s.DiscoveredResource == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveredResource"))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}
	if s.DiscoveredResource != nil {
		if err := s.DiscoveredResource.Validate(); err != nil {
			invalidParams.AddNested("DiscoveredResource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiscoveredResource sets the DiscoveredResource field's value.
func (s *AssociateDiscoveredResourceInput) SetDiscoveredResource(v *DiscoveredResource) *AssociateDiscoveredResourceInput {
	s.DiscoveredResource = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AssociateDiscoveredResourceInput) SetDryRun(v bool) *AssociateDiscoveredResourceInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *AssociateDiscoveredResourceInput) SetMigrationTaskName(v string) *AssociateDiscoveredResourceInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *AssociateDiscoveredResourceInput) SetProgressUpdateStream(v string) *AssociateDiscoveredResourceInput {
	s.ProgressUpdateStream = &v
	return s
}

type AssociateDiscoveredResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDiscoveredResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDiscoveredResourceOutput) GoString() string {
	return s.String()
}

type CreateProgressUpdateStreamInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStreamName is a required field
	ProgressUpdateStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProgressUpdateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProgressUpdateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProgressUpdateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProgressUpdateStreamInput"}
	if s.ProgressUpdateStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStreamName"))
	}
	if s.ProgressUpdateStreamName != nil && len(*s.ProgressUpdateStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *CreateProgressUpdateStreamInput) SetDryRun(v bool) *CreateProgressUpdateStreamInput {
	s.DryRun = &v
	return s
}

// SetProgressUpdateStreamName sets the ProgressUpdateStreamName field's value.
func (s *CreateProgressUpdateStreamInput) SetProgressUpdateStreamName(v string) *CreateProgressUpdateStreamInput {
	s.ProgressUpdateStreamName = &v
	return s
}

type CreateProgressUpdateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateProgressUpdateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProgressUpdateStreamOutput) GoString() string {
	return s.String()
}

// An ARN of the AWS cloud resource target receiving the migration (e.g., AMI,
// EC2 instance, RDS instance, etc.).
type CreatedArtifact struct {
	_ struct{} `type:"structure"`

	// A description that can be free-form text to record additional detail about
	// the artifact for clarity or for later reference.
	Description *string `type:"string"`

	// An ARN that uniquely identifies the result of a migration task.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatedArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatedArtifact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatedArtifact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatedArtifact"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreatedArtifact) SetDescription(v string) *CreatedArtifact {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatedArtifact) SetName(v string) *CreatedArtifact {
	s.Name = &v
	return s
}

type DeleteProgressUpdateStreamInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStreamName is a required field
	ProgressUpdateStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProgressUpdateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProgressUpdateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProgressUpdateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProgressUpdateStreamInput"}
	if s.ProgressUpdateStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStreamName"))
	}
	if s.ProgressUpdateStreamName != nil && len(*s.ProgressUpdateStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteProgressUpdateStreamInput) SetDryRun(v bool) *DeleteProgressUpdateStreamInput {
	s.DryRun = &v
	return s
}

// SetProgressUpdateStreamName sets the ProgressUpdateStreamName field's value.
func (s *DeleteProgressUpdateStreamInput) SetProgressUpdateStreamName(v string) *DeleteProgressUpdateStreamInput {
	s.ProgressUpdateStreamName = &v
	return s
}

type DeleteProgressUpdateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProgressUpdateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProgressUpdateStreamOutput) GoString() string {
	return s.String()
}

type DescribeApplicationStateInput struct {
	_ struct{} `type:"structure"`

	// The configurationId in ADS that uniquely identifies the grouped application.
	//
	// ApplicationId is a required field
	ApplicationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationStateInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DescribeApplicationStateInput) SetApplicationId(v string) *DescribeApplicationStateInput {
	s.ApplicationId = &v
	return s
}

type DescribeApplicationStateOutput struct {
	_ struct{} `type:"structure"`

	// Status of the application - Not Started, In-Progress, Complete.
	ApplicationStatus *string `type:"string" enum:"ApplicationStatus"`

	// The timestamp when the application status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeApplicationStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationStateOutput) GoString() string {
	return s.String()
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *DescribeApplicationStateOutput) SetApplicationStatus(v string) *DescribeApplicationStateOutput {
	s.ApplicationStatus = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeApplicationStateOutput) SetLastUpdatedTime(v time.Time) *DescribeApplicationStateOutput {
	s.LastUpdatedTime = &v
	return s
}

type DescribeMigrationTaskInput struct {
	_ struct{} `type:"structure"`

	// The identifier given to the MigrationTask.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMigrationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMigrationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMigrationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMigrationTaskInput"}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *DescribeMigrationTaskInput) SetMigrationTaskName(v string) *DescribeMigrationTaskInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *DescribeMigrationTaskInput) SetProgressUpdateStream(v string) *DescribeMigrationTaskInput {
	s.ProgressUpdateStream = &v
	return s
}

type DescribeMigrationTaskOutput struct {
	_ struct{} `type:"structure"`

	// Object encapsulating information about the migration task.
	MigrationTask *MigrationTask `type:"structure"`
}

// String returns the string representation
func (s DescribeMigrationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMigrationTaskOutput) GoString() string {
	return s.String()
}

// SetMigrationTask sets the MigrationTask field's value.
func (s *DescribeMigrationTaskOutput) SetMigrationTask(v *MigrationTask) *DescribeMigrationTaskOutput {
	s.MigrationTask = v
	return s
}

type DisassociateCreatedArtifactInput struct {
	_ struct{} `type:"structure"`

	// An ARN of the AWS resource related to the migration (e.g., AMI, EC2 instance,
	// RDS instance, etc.)
	//
	// CreatedArtifactName is a required field
	CreatedArtifactName *string `min:"1" type:"string" required:"true"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task to be disassociated
	// with the artifact.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateCreatedArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateCreatedArtifactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateCreatedArtifactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateCreatedArtifactInput"}
	if s.CreatedArtifactName == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatedArtifactName"))
	}
	if s.CreatedArtifactName != nil && len(*s.CreatedArtifactName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatedArtifactName", 1))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedArtifactName sets the CreatedArtifactName field's value.
func (s *DisassociateCreatedArtifactInput) SetCreatedArtifactName(v string) *DisassociateCreatedArtifactInput {
	s.CreatedArtifactName = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DisassociateCreatedArtifactInput) SetDryRun(v bool) *DisassociateCreatedArtifactInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *DisassociateCreatedArtifactInput) SetMigrationTaskName(v string) *DisassociateCreatedArtifactInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *DisassociateCreatedArtifactInput) SetProgressUpdateStream(v string) *DisassociateCreatedArtifactInput {
	s.ProgressUpdateStream = &v
	return s
}

type DisassociateCreatedArtifactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateCreatedArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateCreatedArtifactOutput) GoString() string {
	return s.String()
}

type DisassociateDiscoveredResourceInput struct {
	_ struct{} `type:"structure"`

	// ConfigurationId of the ADS resource to be disassociated.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `min:"1" type:"string" required:"true"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The identifier given to the MigrationTask.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateDiscoveredResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDiscoveredResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDiscoveredResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDiscoveredResourceInput"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *DisassociateDiscoveredResourceInput) SetConfigurationId(v string) *DisassociateDiscoveredResourceInput {
	s.ConfigurationId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DisassociateDiscoveredResourceInput) SetDryRun(v bool) *DisassociateDiscoveredResourceInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *DisassociateDiscoveredResourceInput) SetMigrationTaskName(v string) *DisassociateDiscoveredResourceInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *DisassociateDiscoveredResourceInput) SetProgressUpdateStream(v string) *DisassociateDiscoveredResourceInput {
	s.ProgressUpdateStream = &v
	return s
}

type DisassociateDiscoveredResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDiscoveredResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDiscoveredResourceOutput) GoString() string {
	return s.String()
}

// Object representing the on-premises resource being migrated.
type DiscoveredResource struct {
	_ struct{} `type:"structure"`

	// The configurationId in ADS that uniquely identifies the on-premise resource.
	//
	// ConfigurationId is a required field
	ConfigurationId *string `min:"1" type:"string" required:"true"`

	// A description that can be free-form text to record additional detail about
	// the discovered resource for clarity or later reference.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DiscoveredResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiscoveredResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoveredResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoveredResource"}
	if s.ConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationId"))
	}
	if s.ConfigurationId != nil && len(*s.ConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *DiscoveredResource) SetConfigurationId(v string) *DiscoveredResource {
	s.ConfigurationId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DiscoveredResource) SetDescription(v string) *DiscoveredResource {
	s.Description = &v
	return s
}

type ImportMigrationTaskInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportMigrationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportMigrationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportMigrationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportMigrationTaskInput"}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *ImportMigrationTaskInput) SetDryRun(v bool) *ImportMigrationTaskInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *ImportMigrationTaskInput) SetMigrationTaskName(v string) *ImportMigrationTaskInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *ImportMigrationTaskInput) SetProgressUpdateStream(v string) *ImportMigrationTaskInput {
	s.ProgressUpdateStream = &v
	return s
}

type ImportMigrationTaskOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportMigrationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportMigrationTaskOutput) GoString() string {
	return s.String()
}

type ListCreatedArtifactsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to be returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListCreatedArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreatedArtifactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCreatedArtifactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCreatedArtifactsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCreatedArtifactsInput) SetMaxResults(v int64) *ListCreatedArtifactsInput {
	s.MaxResults = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *ListCreatedArtifactsInput) SetMigrationTaskName(v string) *ListCreatedArtifactsInput {
	s.MigrationTaskName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreatedArtifactsInput) SetNextToken(v string) *ListCreatedArtifactsInput {
	s.NextToken = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *ListCreatedArtifactsInput) SetProgressUpdateStream(v string) *ListCreatedArtifactsInput {
	s.ProgressUpdateStream = &v
	return s
}

type ListCreatedArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// List of created artifacts up to the maximum number of results specified in
	// the request.
	CreatedArtifactList []*CreatedArtifact `type:"list"`

	// If there are more created artifacts than the max result, return the next
	// token to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCreatedArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCreatedArtifactsOutput) GoString() string {
	return s.String()
}

// SetCreatedArtifactList sets the CreatedArtifactList field's value.
func (s *ListCreatedArtifactsOutput) SetCreatedArtifactList(v []*CreatedArtifact) *ListCreatedArtifactsOutput {
	s.CreatedArtifactList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCreatedArtifactsOutput) SetNextToken(v string) *ListCreatedArtifactsOutput {
	s.NextToken = &v
	return s
}

type ListDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the MigrationTask.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveredResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDiscoveredResourcesInput) SetMaxResults(v int64) *ListDiscoveredResourcesInput {
	s.MaxResults = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *ListDiscoveredResourcesInput) SetMigrationTaskName(v string) *ListDiscoveredResourcesInput {
	s.MigrationTaskName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesInput) SetNextToken(v string) *ListDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *ListDiscoveredResourcesInput) SetProgressUpdateStream(v string) *ListDiscoveredResourcesInput {
	s.ProgressUpdateStream = &v
	return s
}

type ListDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Returned list of discovered resources associated with the given MigrationTask.
	DiscoveredResourceList []*DiscoveredResource `type:"list"`

	// If there are more discovered resources than the max result, return the next
	// token to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetDiscoveredResourceList sets the DiscoveredResourceList field's value.
func (s *ListDiscoveredResourcesOutput) SetDiscoveredResourceList(v []*DiscoveredResource) *ListDiscoveredResourcesOutput {
	s.DiscoveredResourceList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesOutput) SetNextToken(v string) *ListDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

type ListMigrationTasksInput struct {
	_ struct{} `type:"structure"`

	// Value to specify how many results are returned per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`

	// Filter migration tasks by discovered resource name.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMigrationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMigrationTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMigrationTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMigrationTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceName != nil && len(*s.ResourceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMigrationTasksInput) SetMaxResults(v int64) *ListMigrationTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMigrationTasksInput) SetNextToken(v string) *ListMigrationTasksInput {
	s.NextToken = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListMigrationTasksInput) SetResourceName(v string) *ListMigrationTasksInput {
	s.ResourceName = &v
	return s
}

type ListMigrationTasksOutput struct {
	_ struct{} `type:"structure"`

	// Lists the migration task's summary which includes: MigrationTaskName, ProgressPercent,
	// ProgressUpdateStream, Status, and the UpdateDateTime for each task.
	MigrationTaskSummaryList []*MigrationTaskSummary `type:"list"`

	// If there are more migration tasks than the max result, return the next token
	// to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMigrationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMigrationTasksOutput) GoString() string {
	return s.String()
}

// SetMigrationTaskSummaryList sets the MigrationTaskSummaryList field's value.
func (s *ListMigrationTasksOutput) SetMigrationTaskSummaryList(v []*MigrationTaskSummary) *ListMigrationTasksOutput {
	s.MigrationTaskSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMigrationTasksOutput) SetNextToken(v string) *ListMigrationTasksOutput {
	s.NextToken = &v
	return s
}

type ListProgressUpdateStreamsInput struct {
	_ struct{} `type:"structure"`

	// Filter to limit the maximum number of results to list per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// If a NextToken was returned by a previous call, there are more results available.
	// To retrieve the next page of results, make the call again using the returned
	// token in NextToken.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListProgressUpdateStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProgressUpdateStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProgressUpdateStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProgressUpdateStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProgressUpdateStreamsInput) SetMaxResults(v int64) *ListProgressUpdateStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProgressUpdateStreamsInput) SetNextToken(v string) *ListProgressUpdateStreamsInput {
	s.NextToken = &v
	return s
}

type ListProgressUpdateStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more streams created than the max result, return the next token
	// to be passed to the next call as a bookmark of where to start from.
	NextToken *string `type:"string"`

	// List of progress update streams up to the max number of results passed in
	// the input.
	ProgressUpdateStreamSummaryList []*ProgressUpdateStreamSummary `type:"list"`
}

// String returns the string representation
func (s ListProgressUpdateStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProgressUpdateStreamsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProgressUpdateStreamsOutput) SetNextToken(v string) *ListProgressUpdateStreamsOutput {
	s.NextToken = &v
	return s
}

// SetProgressUpdateStreamSummaryList sets the ProgressUpdateStreamSummaryList field's value.
func (s *ListProgressUpdateStreamsOutput) SetProgressUpdateStreamSummaryList(v []*ProgressUpdateStreamSummary) *ListProgressUpdateStreamsOutput {
	s.ProgressUpdateStreamSummaryList = v
	return s
}

// Represents a migration task in a migration tool.
type MigrationTask struct {
	_ struct{} `type:"structure"`

	// Unique identifier that references the migration task.
	MigrationTaskName *string `min:"1" type:"string"`

	// A name that identifies the vendor of the migration tool being used.
	ProgressUpdateStream *string `min:"1" type:"string"`

	ResourceAttributeList []*ResourceAttribute `type:"list"`

	// Task object encapsulating task information.
	Task *Task `type:"structure"`

	// The timestamp when the task was gathered.
	UpdateDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s MigrationTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MigrationTask) GoString() string {
	return s.String()
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *MigrationTask) SetMigrationTaskName(v string) *MigrationTask {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *MigrationTask) SetProgressUpdateStream(v string) *MigrationTask {
	s.ProgressUpdateStream = &v
	return s
}

// SetResourceAttributeList sets the ResourceAttributeList field's value.
func (s *MigrationTask) SetResourceAttributeList(v []*ResourceAttribute) *MigrationTask {
	s.ResourceAttributeList = v
	return s
}

// SetTask sets the Task field's value.
func (s *MigrationTask) SetTask(v *Task) *MigrationTask {
	s.Task = v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *MigrationTask) SetUpdateDateTime(v time.Time) *MigrationTask {
	s.UpdateDateTime = &v
	return s
}

// MigrationTaskSummary includes MigrationTaskName, ProgressPercent, ProgressUpdateStream,
// Status, and UpdateDateTime for each task.
type MigrationTaskSummary struct {
	_ struct{} `type:"structure"`

	// Unique identifier that references the migration task.
	MigrationTaskName *string `min:"1" type:"string"`

	ProgressPercent *int64 `type:"integer"`

	// An AWS resource used for access control. It should uniquely identify the
	// migration tool as it is used for all updates made by the tool.
	ProgressUpdateStream *string `min:"1" type:"string"`

	// Status of the task.
	Status *string `type:"string" enum:"Status"`

	// Detail information of what is being done within the overall status state.
	StatusDetail *string `type:"string"`

	// The timestamp when the task was gathered.
	UpdateDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s MigrationTaskSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MigrationTaskSummary) GoString() string {
	return s.String()
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *MigrationTaskSummary) SetMigrationTaskName(v string) *MigrationTaskSummary {
	s.MigrationTaskName = &v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *MigrationTaskSummary) SetProgressPercent(v int64) *MigrationTaskSummary {
	s.ProgressPercent = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *MigrationTaskSummary) SetProgressUpdateStream(v string) *MigrationTaskSummary {
	s.ProgressUpdateStream = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MigrationTaskSummary) SetStatus(v string) *MigrationTaskSummary {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *MigrationTaskSummary) SetStatusDetail(v string) *MigrationTaskSummary {
	s.StatusDetail = &v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *MigrationTaskSummary) SetUpdateDateTime(v time.Time) *MigrationTaskSummary {
	s.UpdateDateTime = &v
	return s
}

type NotifyApplicationStateInput struct {
	_ struct{} `type:"structure"`

	// The configurationId in ADS that uniquely identifies the grouped application.
	//
	// ApplicationId is a required field
	ApplicationId *string `min:"1" type:"string" required:"true"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Status of the application - Not Started, In-Progress, Complete.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ApplicationStatus"`
}

// String returns the string representation
func (s NotifyApplicationStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyApplicationStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyApplicationStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyApplicationStateInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *NotifyApplicationStateInput) SetApplicationId(v string) *NotifyApplicationStateInput {
	s.ApplicationId = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *NotifyApplicationStateInput) SetDryRun(v bool) *NotifyApplicationStateInput {
	s.DryRun = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NotifyApplicationStateInput) SetStatus(v string) *NotifyApplicationStateInput {
	s.Status = &v
	return s
}

type NotifyApplicationStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NotifyApplicationStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyApplicationStateOutput) GoString() string {
	return s.String()
}

type NotifyMigrationTaskStateInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// Number of seconds after the UpdateDateTime within which the Migration Hub
	// can expect an update. If Migration Hub does not receive an update within
	// the specified interval, then the migration task will be considered stale.
	//
	// NextUpdateSeconds is a required field
	NextUpdateSeconds *int64 `type:"integer" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`

	// Information about the task's progress and status.
	//
	// Task is a required field
	Task *Task `type:"structure" required:"true"`

	// The timestamp when the task was gathered.
	//
	// UpdateDateTime is a required field
	UpdateDateTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s NotifyMigrationTaskStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyMigrationTaskStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyMigrationTaskStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyMigrationTaskStateInput"}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.NextUpdateSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("NextUpdateSeconds"))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}
	if s.Task == nil {
		invalidParams.Add(request.NewErrParamRequired("Task"))
	}
	if s.UpdateDateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateDateTime"))
	}
	if s.Task != nil {
		if err := s.Task.Validate(); err != nil {
			invalidParams.AddNested("Task", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *NotifyMigrationTaskStateInput) SetDryRun(v bool) *NotifyMigrationTaskStateInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *NotifyMigrationTaskStateInput) SetMigrationTaskName(v string) *NotifyMigrationTaskStateInput {
	s.MigrationTaskName = &v
	return s
}

// SetNextUpdateSeconds sets the NextUpdateSeconds field's value.
func (s *NotifyMigrationTaskStateInput) SetNextUpdateSeconds(v int64) *NotifyMigrationTaskStateInput {
	s.NextUpdateSeconds = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *NotifyMigrationTaskStateInput) SetProgressUpdateStream(v string) *NotifyMigrationTaskStateInput {
	s.ProgressUpdateStream = &v
	return s
}

// SetTask sets the Task field's value.
func (s *NotifyMigrationTaskStateInput) SetTask(v *Task) *NotifyMigrationTaskStateInput {
	s.Task = v
	return s
}

// SetUpdateDateTime sets the UpdateDateTime field's value.
func (s *NotifyMigrationTaskStateInput) SetUpdateDateTime(v time.Time) *NotifyMigrationTaskStateInput {
	s.UpdateDateTime = &v
	return s
}

type NotifyMigrationTaskStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NotifyMigrationTaskStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyMigrationTaskStateOutput) GoString() string {
	return s.String()
}

// Summary of the AWS resource used for access control that is implicitly linked
// to your AWS account.
type ProgressUpdateStreamSummary struct {
	_ struct{} `type:"structure"`

	// The name of the ProgressUpdateStream.
	ProgressUpdateStreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ProgressUpdateStreamSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProgressUpdateStreamSummary) GoString() string {
	return s.String()
}

// SetProgressUpdateStreamName sets the ProgressUpdateStreamName field's value.
func (s *ProgressUpdateStreamSummary) SetProgressUpdateStreamName(v string) *ProgressUpdateStreamSummary {
	s.ProgressUpdateStreamName = &v
	return s
}

type PutResourceAttributesInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// Unique identifier that references the migration task.
	//
	// MigrationTaskName is a required field
	MigrationTaskName *string `min:"1" type:"string" required:"true"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStream is a required field
	ProgressUpdateStream *string `min:"1" type:"string" required:"true"`

	// Information about the resource that is being migrated. This data will be
	// used to map the task to a resource in the Application Discovery Service (ADS)'s
	// repository.
	//
	// Takes the object array of ResourceAttribute where the Type field is reserved
	// for the following values: IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN
	// | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID
	// | MOTHERBOARD_SERIAL_NUMBER where the identifying value can be a string up
	// to 256 characters.
	//
	// If any "VM" related value is set for a ResourceAttribute object, it is required
	// that VM_MANAGER_ID, as a minimum, is always set. If VM_MANAGER_ID is not
	// set, then all "VM" fields will be discarded and "VM" fields will not be used
	// for matching the migration task to a server in Application Discovery Service
	// (ADS)'s repository. See the Example (https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples)
	// section below for a use case of specifying "VM" related values.
	//
	//  If a server you are trying to match has multiple IP or MAC addresses, you
	// should provide as many as you know in separate type/value pairs passed to
	// the ResourceAttributeList parameter to maximize the chances of matching.
	//
	// ResourceAttributeList is a required field
	ResourceAttributeList []*ResourceAttribute `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutResourceAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourceAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourceAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourceAttributesInput"}
	if s.MigrationTaskName == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationTaskName"))
	}
	if s.MigrationTaskName != nil && len(*s.MigrationTaskName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MigrationTaskName", 1))
	}
	if s.ProgressUpdateStream == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgressUpdateStream"))
	}
	if s.ProgressUpdateStream != nil && len(*s.ProgressUpdateStream) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgressUpdateStream", 1))
	}
	if s.ResourceAttributeList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceAttributeList"))
	}
	if s.ResourceAttributeList != nil && len(s.ResourceAttributeList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceAttributeList", 1))
	}
	if s.ResourceAttributeList != nil {
		for i, v := range s.ResourceAttributeList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceAttributeList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *PutResourceAttributesInput) SetDryRun(v bool) *PutResourceAttributesInput {
	s.DryRun = &v
	return s
}

// SetMigrationTaskName sets the MigrationTaskName field's value.
func (s *PutResourceAttributesInput) SetMigrationTaskName(v string) *PutResourceAttributesInput {
	s.MigrationTaskName = &v
	return s
}

// SetProgressUpdateStream sets the ProgressUpdateStream field's value.
func (s *PutResourceAttributesInput) SetProgressUpdateStream(v string) *PutResourceAttributesInput {
	s.ProgressUpdateStream = &v
	return s
}

// SetResourceAttributeList sets the ResourceAttributeList field's value.
func (s *PutResourceAttributesInput) SetResourceAttributeList(v []*ResourceAttribute) *PutResourceAttributesInput {
	s.ResourceAttributeList = v
	return s
}

type PutResourceAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutResourceAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutResourceAttributesOutput) GoString() string {
	return s.String()
}

// Attribute associated with a resource.
//
// Note the corresponding format required per type listed below:
//
// IPV4x.x.x.x
//
// where x is an integer in the range [0,255]
//
// IPV6y : y : y : y : y : y : y : y
//
// where y is a hexadecimal between 0 and FFFF. [0, FFFF]
//
// MAC_ADDRESS^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$
//
// FQDN^[^<>{}\\\\/?,=\\p{Cntrl}]{1,256}$
type ResourceAttribute struct {
	_ struct{} `type:"structure"`

	// Type of resource.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ResourceAttributeType"`

	// Value of the resource type.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceAttribute"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ResourceAttribute) SetType(v string) *ResourceAttribute {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceAttribute) SetValue(v string) *ResourceAttribute {
	s.Value = &v
	return s
}

// Task object encapsulating task information.
type Task struct {
	_ struct{} `type:"structure"`

	// Indication of the percentage completion of the task.
	ProgressPercent *int64 `type:"integer"`

	// Status of the task - Not Started, In-Progress, Complete.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`

	// Details of task status as notified by a migration tool. A tool might use
	// this field to provide clarifying information about the status that is unique
	// to that tool or that explains an error state.
	StatusDetail *string `type:"string"`
}

// String returns the string representation
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Task) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Task) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Task"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *Task) SetProgressPercent(v int64) *Task {
	s.ProgressPercent = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Task) SetStatus(v string) *Task {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *Task) SetStatusDetail(v string) *Task {
	s.StatusDetail = &v
	return s
}

const (
	// ApplicationStatusNotStarted is a ApplicationStatus enum value
	ApplicationStatusNotStarted = "NOT_STARTED"

	// ApplicationStatusInProgress is a ApplicationStatus enum value
	ApplicationStatusInProgress = "IN_PROGRESS"

	// ApplicationStatusCompleted is a ApplicationStatus enum value
	ApplicationStatusCompleted = "COMPLETED"
)

const (
	// ResourceAttributeTypeIpv4Address is a ResourceAttributeType enum value
	ResourceAttributeTypeIpv4Address = "IPV4_ADDRESS"

	// ResourceAttributeTypeIpv6Address is a ResourceAttributeType enum value
	ResourceAttributeTypeIpv6Address = "IPV6_ADDRESS"

	// ResourceAttributeTypeMacAddress is a ResourceAttributeType enum value
	ResourceAttributeTypeMacAddress = "MAC_ADDRESS"

	// ResourceAttributeTypeFqdn is a ResourceAttributeType enum value
	ResourceAttributeTypeFqdn = "FQDN"

	// ResourceAttributeTypeVmManagerId is a ResourceAttributeType enum value
	ResourceAttributeTypeVmManagerId = "VM_MANAGER_ID"

	// ResourceAttributeTypeVmManagedObjectReference is a ResourceAttributeType enum value
	ResourceAttributeTypeVmManagedObjectReference = "VM_MANAGED_OBJECT_REFERENCE"

	// ResourceAttributeTypeVmName is a ResourceAttributeType enum value
	ResourceAttributeTypeVmName = "VM_NAME"

	// ResourceAttributeTypeVmPath is a ResourceAttributeType enum value
	ResourceAttributeTypeVmPath = "VM_PATH"

	// ResourceAttributeTypeBiosId is a ResourceAttributeType enum value
	ResourceAttributeTypeBiosId = "BIOS_ID"

	// ResourceAttributeTypeMotherboardSerialNumber is a ResourceAttributeType enum value
	ResourceAttributeTypeMotherboardSerialNumber = "MOTHERBOARD_SERIAL_NUMBER"
)

const (
	// StatusNotStarted is a Status enum value
	StatusNotStarted = "NOT_STARTED"

	// StatusInProgress is a Status enum value
	StatusInProgress = "IN_PROGRESS"

	// StatusFailed is a Status enum value
	StatusFailed = "FAILED"

	// StatusCompleted is a Status enum value
	StatusCompleted = "COMPLETED"
)
