package postgres

import (
	"strconv"

	"github.com/quay/claircore"
)

type scanner interface {
	Scan(dest ...interface{}) error
}

func scanVulnerability(v *claircore.Vulnerability, row scanner) error {
	var id uint64
	if err := row.Scan(
		&id,
		&v.Name,
		&v.Updater,
		&v.Description,
		&v.Issued,
		&v.Links,
		&v.Severity,
		&v.NormalizedSeverity,
		&v.Package.Name,
		&v.Package.Version,
		&v.Package.Module,
		&v.Package.Arch,
		&v.Package.Kind,
		&v.Dist.DID,
		&v.Dist.Name,
		&v.Dist.Version,
		&v.Dist.VersionCodeName,
		&v.Dist.VersionID,
		&v.Dist.Arch,
		&v.Dist.CPE,
		&v.Dist.PrettyName,
		&v.ArchOperation,
		&v.Repo.Name,
		&v.Repo.Key,
		&v.Repo.URI,
		&v.FixedInVersion,
	); err != nil {
		return err
	}
	v.ID = strconv.FormatUint(id, 10)
	return nil
}
