package vulnstore

import (
	"context"

	"github.com/quay/claircore"
	"github.com/quay/claircore/libvuln/driver"
)

// GetOpts provides instructions on how to
// match your packages to vulnerabilities.
type GetOpts struct {
	// Matchers tells the Get() method to limit the returned vulnerabilities by the provided MatchConstraint
	// see MatchConstraint type def for more info.
	Matchers []driver.MatchConstraint
	// Debug asks the database layer to log exta information
	Debug bool
	// VersionFiltering enables filtering based on the normalized versions in
	// the database.
	VersionFiltering bool
}

type Vulnerability interface {
	// get finds the vulnerabilities which match each package provided in the packages array
	// this maybe a one to many relationship. each package is assumed to have an ID.
	// a map of Package.ID => Vulnerabilities is returned.
	Get(ctx context.Context, records []*claircore.IndexRecord, opts GetOpts) (map[string][]*claircore.Vulnerability, error)
}
