/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	time "time"

	secscanv1alpha1 "github.com/quay/container-security-operator/apis/secscan/v1alpha1"
	internalinterfaces "github.com/quay/container-security-operator/generated/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/quay/container-security-operator/generated/listers/secscan/v1alpha1"
	versioned "github.com/quay/container-security-operator/generated/versioned"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ImageManifestVulnInformer provides access to a shared informer and lister for
// ImageManifestVulns.
type ImageManifestVulnInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.ImageManifestVulnLister
}

type imageManifestVulnInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewImageManifestVulnInformer constructs a new informer for ImageManifestVuln type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewImageManifestVulnInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredImageManifestVulnInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredImageManifestVulnInformer constructs a new informer for ImageManifestVuln type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredImageManifestVulnInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.SecscanV1alpha1().ImageManifestVulns(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.SecscanV1alpha1().ImageManifestVulns(namespace).Watch(options)
			},
		},
		&secscanv1alpha1.ImageManifestVuln{},
		resyncPeriod,
		indexers,
	)
}

func (f *imageManifestVulnInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredImageManifestVulnInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *imageManifestVulnInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&secscanv1alpha1.ImageManifestVuln{}, f.defaultInformer)
}

func (f *imageManifestVulnInformer) Lister() v1alpha1.ImageManifestVulnLister {
	return v1alpha1.NewImageManifestVulnLister(f.Informer().GetIndexer())
}
