# Contributing to DockerSlim

If you want to contribute submit a GitHub pull request or open an issue. Thank you!

## TL;DR

Any contribution is better than no contribution :-) Submit a [pull request](https://help.github.com/articles/using-pull-requests) or open an issue even if you are not sure or if you feel the contribution is not significant enough. If you want to accelerate the process you can follow the guidelines below.

## Guidelines

### Reporting Issues

Open an issue and provide enough cotext information to repro the condition. Don't worry if it's not possible to reproduce (reliably). Submit an issue anyways including the information you do have. The version information should be provided in all bug reports.

### Environment Setup

See the `BUILD PROCESS` section in the `README.md` file.

### Enhancements

Take a look at the open issues or feel free to create a new issue if what you'd like to do doesn't have an issue already. This includes documentation enhancements and design proposals too. When you submit your [pull request](https://help.github.com/articles/using-pull-requests) make sure to reference the issue.

### Coding Standards

The coding standards are based on the [Golang community standards](https://github.com/golang/go/wiki/CodeReviewComments). Make sure to leverage the `scripts/src.fmt.sh` and `scripts/src.inspect.sh` helper scripts or their equivalent.

### Dependencies

TBD - information about adding dependencies to DockerSlim

### Testing

Yes :-)

### Documentation

Yes :-)

### Pull Requests

Standard guidelines for [pull requests](https://help.github.com/articles/using-pull-requests)
