package claircore

import (
	"time"
)

type Vulnerability struct {
	// unique ID of this vulnerability. this will be created as discovered by the library
	// and used for persistence and hash map indexes
	ID string `json:"id"`
	// the updater that discovered this vulnerability
	Updater string `json:"updater"`
	// the name of the vulnerability. for example if the vulnerability exists in a CVE database this
	// would the unique CVE name such as CVE-2017-11722
	Name string `json:"name"`
	// the description of the vulnerability
	Description string `json:"description"`
	// the timestamp when vulnerability was issued
	Issued time.Time `json:"issued"`
	// any links to more details about the vulnerability
	Links string `json:"links"`
	// the severity string retrieved from the security database
	Severity string `json:"severity"`
	// a normalized Severity type providing client guaranteed severity information
	NormalizedSeverity Severity `json:"normalized_severity"`
	// the package information associated with the vulnerability. ideally these fields can be matched
	// to packages discovered by libindex PackageScanner structs.
	Package *Package `json:"package"`
	// the distribution information associated with the vulnerability.
	Dist *Distribution `json:"distribution,omitempty"`
	// the repository information associated with the vulnerability
	Repo *Repository `json:"repository,omitempty"`
	// a string specifying the package version the fix was released in
	FixedInVersion string `json:"fixed_in_version"`
	// Range describes the range of versions that are vulnerable.
	Range *Range `json:"range,omitempty"`
	// ArchOperation indicates how the affected Package's "arch" should be
	// compared.
	ArchOperation ArchOp `json:"arch_op,omitempty"`
}
