"""
Add support for app specific tokens.

Revision ID: 7367229b38d9
Revises: d8989249f8f6
Create Date: 2017-12-12 13:15:42.419764
"""

# revision identifiers, used by Alembic.
revision = "7367229b38d9"
down_revision = "d8989249f8f6"

import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from util.migrate import UTF8CharField


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "appspecificauthtoken",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("uuid", sa.String(length=36), nullable=False),
        sa.Column("title", UTF8CharField(length=255), nullable=False),
        sa.Column("token_code", sa.String(length=255), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("expiration", sa.DateTime(), nullable=True),
        sa.Column("last_accessed", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["user_id"], ["user.id"], name=op.f("fk_appspecificauthtoken_user_id_user")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_appspecificauthtoken")),
    )
    op.create_index(
        "appspecificauthtoken_token_code", "appspecificauthtoken", ["token_code"], unique=True
    )
    op.create_index(
        "appspecificauthtoken_user_id", "appspecificauthtoken", ["user_id"], unique=False
    )
    op.create_index(
        "appspecificauthtoken_user_id_expiration",
        "appspecificauthtoken",
        ["user_id", "expiration"],
        unique=False,
    )
    op.create_index("appspecificauthtoken_uuid", "appspecificauthtoken", ["uuid"], unique=False)
    # ### end Alembic commands ###

    op.bulk_insert(
        tables.logentrykind,
        [
            {"name": "create_app_specific_token"},
            {"name": "revoke_app_specific_token"},
        ],
    )

    # ### population of test data ### #
    tester.populate_table(
        "appspecificauthtoken",
        [
            ("user_id", tester.TestDataType.Foreign("user")),
            ("uuid", tester.TestDataType.UUID),
            ("title", tester.TestDataType.UTF8Char),
            ("token_code", tester.TestDataType.String),
            ("created", tester.TestDataType.DateTime),
            ("expiration", tester.TestDataType.DateTime),
            ("last_accessed", tester.TestDataType.DateTime),
        ],
    )
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("appspecificauthtoken")
    # ### end Alembic commands ###

    op.execute(
        tables.logentrykind.delete().where(
            tables.logentrykind.name == op.inline_literal("create_app_specific_token")
        )
    )

    op.execute(
        tables.logentrykind.delete().where(
            tables.logentrykind.name == op.inline_literal("revoke_app_specific_token")
        )
    )
