"""
Add new fields and tables for encrypted tokens.

Revision ID: c13c8052f7a6
Revises: 5248ddf35167
Create Date: 2019-08-19 15:59:36.269155
"""

# revision identifiers, used by Alembic.
revision = "c13c8052f7a6"
down_revision = "5248ddf35167"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "robotaccounttoken",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("robot_account_id", sa.Integer(), nullable=False),
        sa.Column("token", sa.String(length=255), nullable=False),
        sa.Column("fully_migrated", sa.Boolean(), nullable=False, server_default="0"),
        sa.ForeignKeyConstraint(
            ["robot_account_id"],
            ["user.id"],
            name=op.f("fk_robotaccounttoken_robot_account_id_user"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_robotaccounttoken")),
    )
    op.create_index(
        "robotaccounttoken_robot_account_id", "robotaccounttoken", ["robot_account_id"], unique=True
    )

    op.add_column("accesstoken", sa.Column("token_code", sa.String(length=255), nullable=True))
    op.add_column("accesstoken", sa.Column("token_name", sa.String(length=255), nullable=True))
    op.create_index("accesstoken_token_name", "accesstoken", ["token_name"], unique=True)

    op.add_column(
        "appspecificauthtoken", sa.Column("token_name", sa.String(length=255), nullable=True)
    )
    op.add_column(
        "appspecificauthtoken", sa.Column("token_secret", sa.String(length=255), nullable=True)
    )
    op.create_index(
        "appspecificauthtoken_token_name", "appspecificauthtoken", ["token_name"], unique=True
    )

    op.add_column(
        "emailconfirmation", sa.Column("verification_code", sa.String(length=255), nullable=True)
    )

    op.add_column("oauthaccesstoken", sa.Column("token_code", sa.String(length=255), nullable=True))
    op.add_column("oauthaccesstoken", sa.Column("token_name", sa.String(length=255), nullable=True))
    op.create_index("oauthaccesstoken_token_name", "oauthaccesstoken", ["token_name"], unique=True)

    op.add_column(
        "oauthapplication", sa.Column("secure_client_secret", sa.String(length=255), nullable=True)
    )
    op.add_column(
        "oauthapplication",
        sa.Column("fully_migrated", sa.Boolean(), server_default="0", nullable=False),
    )

    op.add_column(
        "oauthauthorizationcode",
        sa.Column("code_credential", sa.String(length=255), nullable=True),
    )
    op.add_column(
        "oauthauthorizationcode", sa.Column("code_name", sa.String(length=255), nullable=True)
    )
    op.create_index(
        "oauthauthorizationcode_code_name", "oauthauthorizationcode", ["code_name"], unique=True
    )
    op.drop_index("oauthauthorizationcode_code", table_name="oauthauthorizationcode")
    op.create_index("oauthauthorizationcode_code", "oauthauthorizationcode", ["code"], unique=True)

    op.add_column(
        "repositorybuildtrigger",
        sa.Column("secure_auth_token", sa.String(length=255), nullable=True),
    )
    op.add_column(
        "repositorybuildtrigger", sa.Column("secure_private_key", sa.Text(), nullable=True)
    )
    op.add_column(
        "repositorybuildtrigger",
        sa.Column("fully_migrated", sa.Boolean(), server_default="0", nullable=False),
    )
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_table(
        "robotaccounttoken",
        [
            ("robot_account_id", tester.TestDataType.Foreign("user")),
            ("token", tester.TestDataType.Token),
            ("fully_migrated", tester.TestDataType.Boolean),
        ],
    )

    tester.populate_column("accesstoken", "code", tester.TestDataType.Token)

    tester.populate_column("appspecificauthtoken", "token_code", tester.TestDataType.Token)

    tester.populate_column("emailconfirmation", "verification_code", tester.TestDataType.Token)

    tester.populate_column("oauthaccesstoken", "token_code", tester.TestDataType.Token)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("repositorybuildtrigger", "secure_private_key")
    op.drop_column("repositorybuildtrigger", "secure_auth_token")

    op.drop_index("oauthauthorizationcode_code", table_name="oauthauthorizationcode")
    op.create_index("oauthauthorizationcode_code", "oauthauthorizationcode", ["code"], unique=False)
    op.drop_index("oauthauthorizationcode_code_name", table_name="oauthauthorizationcode")
    op.drop_column("oauthauthorizationcode", "code_name")
    op.drop_column("oauthauthorizationcode", "code_credential")

    op.drop_column("oauthapplication", "secure_client_secret")

    op.drop_index("oauthaccesstoken_token_name", table_name="oauthaccesstoken")
    op.drop_column("oauthaccesstoken", "token_name")
    op.drop_column("oauthaccesstoken", "token_code")

    op.drop_column("emailconfirmation", "verification_code")

    op.drop_index("appspecificauthtoken_token_name", table_name="appspecificauthtoken")
    op.drop_column("appspecificauthtoken", "token_secret")
    op.drop_column("appspecificauthtoken", "token_name")

    op.drop_index("accesstoken_token_name", table_name="accesstoken")
    op.drop_column("accesstoken", "token_name")
    op.drop_column("accesstoken", "token_code")

    op.drop_table("robotaccounttoken")
    # ### end Alembic commands ###
