"""
Add last_accessed field to User table.

Revision ID: 224ce4c72c2f
Revises: b547bc139ad8
Create Date: 2018-03-12 22:44:07.070490
"""

# revision identifiers, used by Alembic.
revision = "224ce4c72c2f"
down_revision = "b547bc139ad8"

import sqlalchemy as sa


def upgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("user", sa.Column("last_accessed", sa.DateTime(), nullable=True))
    op.create_index("user_last_accessed", "user", ["last_accessed"], unique=False)
    # ### end Alembic commands ###

    # ### population of test data ### #
    tester.populate_column("user", "last_accessed", tester.TestDataType.DateTime)
    # ### end population of test data ### #


def downgrade(op, tables, tester):
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("user_last_accessed", table_name="user")
    op.drop_column("user", "last_accessed")
    # ### end Alembic commands ###
