"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var node_1 = require("../typeguard/node");
var util_1 = require("./util");
var ts = require("typescript");
var DeclarationDomain;
(function (DeclarationDomain) {
    DeclarationDomain[DeclarationDomain["Namespace"] = 1] = "Namespace";
    DeclarationDomain[DeclarationDomain["Type"] = 2] = "Type";
    DeclarationDomain[DeclarationDomain["Value"] = 4] = "Value";
    DeclarationDomain[DeclarationDomain["Any"] = 7] = "Any";
})(DeclarationDomain = exports.DeclarationDomain || (exports.DeclarationDomain = {}));
var UsageDomain;
(function (UsageDomain) {
    UsageDomain[UsageDomain["Namespace"] = 1] = "Namespace";
    UsageDomain[UsageDomain["Type"] = 2] = "Type";
    UsageDomain[UsageDomain["Value"] = 4] = "Value";
    UsageDomain[UsageDomain["ValueOrNamespace"] = 5] = "ValueOrNamespace";
    UsageDomain[UsageDomain["Any"] = 7] = "Any";
    UsageDomain[UsageDomain["TypeQuery"] = 8] = "TypeQuery";
})(UsageDomain = exports.UsageDomain || (exports.UsageDomain = {}));
function getUsageDomain(node) {
    var parent = node.parent;
    switch (parent.kind) {
        case ts.SyntaxKind.TypeReference:
        case ts.SyntaxKind.TypeOperator:
            return 2;
        case ts.SyntaxKind.ExpressionWithTypeArguments:
            return parent.parent.token === ts.SyntaxKind.ImplementsKeyword ||
                parent.parent.parent.kind === ts.SyntaxKind.InterfaceDeclaration
                ? 2
                : 4;
        case ts.SyntaxKind.TypeQuery:
            return 5 | 8;
        case ts.SyntaxKind.QualifiedName:
            if (parent.left === node) {
                if (getEntityNameParent(parent).kind === ts.SyntaxKind.TypeQuery)
                    return 1 | 8;
                return 1;
            }
            break;
        case ts.SyntaxKind.NamespaceExportDeclaration:
            return 1;
        case ts.SyntaxKind.ExportSpecifier:
            if (parent.propertyName === undefined ||
                parent.propertyName === node)
                return 7;
            break;
        case ts.SyntaxKind.ExportAssignment:
            return 7;
        case ts.SyntaxKind.BindingElement:
            if (parent.initializer === node)
                return 5;
            break;
        case ts.SyntaxKind.EnumMember:
        case ts.SyntaxKind.PropertyDeclaration:
        case ts.SyntaxKind.Parameter:
        case ts.SyntaxKind.VariableDeclaration:
        case ts.SyntaxKind.PropertyAssignment:
        case ts.SyntaxKind.PropertyAccessExpression:
        case ts.SyntaxKind.ImportEqualsDeclaration:
            if (parent.name !== node)
                return 5;
            break;
        case ts.SyntaxKind.JsxAttribute:
        case ts.SyntaxKind.FunctionDeclaration:
        case ts.SyntaxKind.FunctionExpression:
        case ts.SyntaxKind.NamespaceImport:
        case ts.SyntaxKind.ClassDeclaration:
        case ts.SyntaxKind.ClassExpression:
        case ts.SyntaxKind.ModuleDeclaration:
        case ts.SyntaxKind.MethodDeclaration:
        case ts.SyntaxKind.EnumDeclaration:
        case ts.SyntaxKind.GetAccessor:
        case ts.SyntaxKind.SetAccessor:
        case ts.SyntaxKind.LabeledStatement:
        case ts.SyntaxKind.ImportClause:
        case ts.SyntaxKind.ImportSpecifier:
        case ts.SyntaxKind.TypePredicate:
        case ts.SyntaxKind.MethodSignature:
        case ts.SyntaxKind.PropertySignature:
        case ts.SyntaxKind.NamespaceExportDeclaration:
        case ts.SyntaxKind.QualifiedName:
        case ts.SyntaxKind.TypeReference:
        case ts.SyntaxKind.TypeOperator:
        case ts.SyntaxKind.InterfaceDeclaration:
        case ts.SyntaxKind.TypeAliasDeclaration:
        case ts.SyntaxKind.TypeParameter:
            break;
        default:
            return 5;
    }
}
exports.getUsageDomain = getUsageDomain;
function collectVariableUsage(sourceFile) {
    return new UsageWalker().getUsage(sourceFile);
}
exports.collectVariableUsage = collectVariableUsage;
var AbstractScope = (function () {
    function AbstractScope(_global) {
        this._global = _global;
        this._variables = new Map();
        this._uses = [];
        this._namespaceScopes = undefined;
        this._enumScopes = undefined;
    }
    AbstractScope.prototype.addVariable = function (identifier, name, blockScoped, exported, domain) {
        var variables = this._getDestinationScope(blockScoped).getVariables();
        var variable = variables.get(identifier);
        if (variable === undefined) {
            variable = {
                domain: domain,
                exported: exported,
                declarations: [name],
                uses: [],
                inGlobalScope: this._global,
            };
            variables.set(identifier, variable);
        }
        else {
            variable.domain |= domain;
            variable.declarations.push(name);
        }
    };
    AbstractScope.prototype.addUse = function (use) {
        this._uses.push(use);
    };
    AbstractScope.prototype.getVariables = function () {
        return this._variables;
    };
    AbstractScope.prototype.getFunctionScope = function () {
        return this;
    };
    AbstractScope.prototype.end = function (cb) {
        for (var _i = 0, _a = this._uses; _i < _a.length; _i++) {
            var use = _a[_i];
            var variable = this._variables.get(use.location.text);
            if (variable !== undefined && variable.domain & use.domain) {
                variable.uses.push(use);
            }
            else {
                this._addUseToParent(use);
            }
        }
        return this._variables.forEach(cb);
    };
    AbstractScope.prototype.settle = function () {
        throw new Error('not supported');
    };
    AbstractScope.prototype.markExported = function (_name) { };
    AbstractScope.prototype.createOrReuseNamespaceScope = function (name, _exported) {
        var scope;
        if (this._namespaceScopes === undefined) {
            this._namespaceScopes = new Map();
        }
        else {
            scope = this._namespaceScopes.get(name);
        }
        if (scope === undefined) {
            scope = new NamespaceScope(this);
            this._namespaceScopes.set(name, scope);
        }
        else {
            scope.refresh(this);
        }
        return scope;
    };
    AbstractScope.prototype.createOrReuseEnumScope = function (name, _exported) {
        var scope;
        if (this._enumScopes === undefined) {
            this._enumScopes = new Map();
        }
        else {
            scope = this._enumScopes.get(name);
        }
        if (scope === undefined) {
            scope = new EnumScope(this);
            this._enumScopes.set(name, scope);
        }
        else {
            scope.refresh();
        }
        return scope;
    };
    AbstractScope.prototype._getDestinationScope = function (_blockScoped) {
        return this;
    };
    AbstractScope.prototype._addUseToParent = function (_use) { };
    return AbstractScope;
}());
var RootScope = (function (_super) {
    __extends(RootScope, _super);
    function RootScope() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._exports = undefined;
        return _this;
    }
    RootScope.prototype.markExported = function (_a) {
        var text = _a.text;
        var variable = this._variables.get(text);
        if (variable !== undefined) {
            variable.exported = true;
        }
        else if (this._exports === undefined) {
            this._exports = [text];
        }
        else {
            this._exports.push(text);
        }
    };
    RootScope.prototype.end = function (cb) {
        if (this._exports !== undefined) {
            for (var _i = 0, _a = this._exports; _i < _a.length; _i++) {
                var exported = _a[_i];
                var variable = this._variables.get(exported);
                if (variable !== undefined)
                    variable.exported = true;
            }
        }
        return _super.prototype.end.call(this, cb);
    };
    return RootScope;
}(AbstractScope));
var NonRootScope = (function (_super) {
    __extends(NonRootScope, _super);
    function NonRootScope(_parent) {
        var _this = _super.call(this, false) || this;
        _this._parent = _parent;
        return _this;
    }
    NonRootScope.prototype._addUseToParent = function (use) {
        return this._parent.addUse(use);
    };
    return NonRootScope;
}(AbstractScope));
var EnumScope = (function (_super) {
    __extends(EnumScope, _super);
    function EnumScope() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EnumScope.prototype.end = function () {
        _super.prototype.end.call(this, function () { });
    };
    EnumScope.prototype.refresh = function () {
        this._uses.length = 0;
    };
    return EnumScope;
}(NonRootScope));
var FunctionScope = (function (_super) {
    __extends(FunctionScope, _super);
    function FunctionScope() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FunctionScope.prototype.settle = function () {
        var newUses = [];
        for (var _i = 0, _a = this._uses; _i < _a.length; _i++) {
            var use = _a[_i];
            if ((use.domain & 4) !== 0 && (use.domain & 8) === 0) {
                var variable = this._variables.get(use.location.text);
                if (variable !== undefined && variable.domain & use.domain) {
                    variable.uses.push(use);
                }
                else {
                    this._addUseToParent(use);
                }
            }
            else {
                newUses.push(use);
            }
        }
        this._uses = newUses;
    };
    return FunctionScope;
}(NonRootScope));
var FunctionExpressionInnerScope = (function (_super) {
    __extends(FunctionExpressionInnerScope, _super);
    function FunctionExpressionInnerScope() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FunctionExpressionInnerScope.prototype._addUseToParent = function (use) {
        return this._parent.addUseToParent(use);
    };
    return FunctionExpressionInnerScope;
}(FunctionScope));
var FunctionExpressionScope = (function (_super) {
    __extends(FunctionExpressionScope, _super);
    function FunctionExpressionScope(_name, parent) {
        var _this = _super.call(this, parent) || this;
        _this._name = _name;
        _this._innerScope = new FunctionExpressionInnerScope(_this);
        return _this;
    }
    FunctionExpressionScope.prototype.end = function (cb) {
        this._innerScope.end(cb);
        return cb({
            declarations: [this._name],
            domain: 4,
            exported: false,
            uses: this._uses,
            inGlobalScope: false,
        }, this._name.text);
    };
    FunctionExpressionScope.prototype.settle = function () {
        return this._innerScope.settle();
    };
    FunctionExpressionScope.prototype.addUseToParent = function (use) {
        if (use.domain & 4 && use.location.text === this._name.text) {
            this._uses.push(use);
        }
        else {
            return this._parent.addUse(use);
        }
    };
    FunctionExpressionScope.prototype.addUse = function (use) {
        return this._innerScope.addUse(use);
    };
    FunctionExpressionScope.prototype._getDestinationScope = function () {
        return this._innerScope;
    };
    return FunctionExpressionScope;
}(NonRootScope));
var BlockScope = (function (_super) {
    __extends(BlockScope, _super);
    function BlockScope(_functionScope, parent) {
        var _this = _super.call(this, parent) || this;
        _this._functionScope = _functionScope;
        return _this;
    }
    BlockScope.prototype.getFunctionScope = function () {
        return this._functionScope;
    };
    BlockScope.prototype._getDestinationScope = function (blockScoped) {
        return blockScoped ? this : this._functionScope;
    };
    return BlockScope;
}(NonRootScope));
var NamespaceInnerScope = (function (_super) {
    __extends(NamespaceInnerScope, _super);
    function NamespaceInnerScope() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NamespaceInnerScope.prototype._addUseToParent = function (use) {
        this._parent.addUseFromInner(use);
    };
    return NamespaceInnerScope;
}(NonRootScope));
var NamespaceScope = (function (_super) {
    __extends(NamespaceScope, _super);
    function NamespaceScope() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._innerScope = new NamespaceInnerScope(_this);
        return _this;
    }
    NamespaceScope.prototype.end = function (cb) {
        var _this = this;
        this._innerScope.end(function (variable, key) {
            if (!variable.exported)
                return cb(variable, key);
            var namespaceVar = _this._variables.get(key);
            if (namespaceVar === undefined) {
                _this._variables.set(key, variable);
            }
            else {
                (_a = namespaceVar.declarations).push.apply(_a, variable.declarations);
                namespaceVar.domain |= variable.domain;
                (_b = namespaceVar.uses).push.apply(_b, variable.uses);
            }
            var _a, _b;
        });
        return _super.prototype.end.call(this, cb);
    };
    NamespaceScope.prototype.createOrReuseNamespaceScope = function (name, exported) {
        if (!exported)
            return this._innerScope.createOrReuseNamespaceScope(name, exported);
        return _super.prototype.createOrReuseNamespaceScope.call(this, name, exported);
    };
    NamespaceScope.prototype.createOrReuseEnumScope = function (name, exported) {
        if (!exported)
            return this._innerScope.createOrReuseEnumScope(name, exported);
        return _super.prototype.createOrReuseEnumScope.call(this, name, exported);
    };
    NamespaceScope.prototype.refresh = function (newParent) {
        this._innerScope = new NamespaceInnerScope(this);
        this._parent = newParent;
        this._uses.length = 0;
    };
    NamespaceScope.prototype.addUse = function (use) {
        return this._innerScope.addUse(use);
    };
    NamespaceScope.prototype.addUseFromInner = function (use) {
        this._uses.push(use);
    };
    NamespaceScope.prototype._getDestinationScope = function () {
        return this._innerScope;
    };
    return NamespaceScope;
}(NonRootScope));
function getEntityNameParent(name) {
    var parent = name.parent;
    while (parent.kind === ts.SyntaxKind.QualifiedName)
        parent = parent.parent;
    return parent;
}
var UsageWalker = (function () {
    function UsageWalker() {
        this._result = new Map();
    }
    UsageWalker.prototype.getUsage = function (sourceFile) {
        var _this = this;
        var variableCallback = function (variable) {
            for (var _i = 0, _a = variable.declarations; _i < _a.length; _i++) {
                var declaration = _a[_i];
                _this._result.set(declaration, variable);
            }
        };
        this._scope = new RootScope(!ts.isExternalModule(sourceFile));
        var cb = function (node) {
            var boundary = util_1.isScopeBoundary(node);
            if (boundary) {
                var savedScope = _this._scope;
                if (boundary === 1) {
                    if (node_1.isFunctionExpression(node) && node.name !== undefined) {
                        _this._scope = new FunctionExpressionScope(node.name, _this._scope);
                    }
                    else if (node_1.isModuleDeclaration(node) && node.name.kind === ts.SyntaxKind.Identifier) {
                        _this._handleNamespace(node);
                        _this._scope = _this._scope.createOrReuseNamespaceScope(node.name.text, isNamespaceExported(node));
                    }
                    else if (node_1.isEnumDeclaration(node)) {
                        _this._handleDeclaration(node, true, 7);
                        _this._scope = _this._scope.createOrReuseEnumScope(node.name.text, util_1.hasModifier(node.modifiers, ts.SyntaxKind.ExportKeyword));
                    }
                    else {
                        if (node_1.isFunctionDeclaration(node) && node.body !== undefined) {
                            _this._handleDeclaration(node, false, 4);
                        }
                        else if (node_1.isClassLikeDeclaration(node)) {
                            _this._handleDeclaration(node, true, 4 | 2);
                        }
                        else if (node_1.isInterfaceDeclaration(node) || node_1.isTypeAliasDeclaration(node)) {
                            _this._handleDeclaration(node, true, 2);
                        }
                        _this._scope = new FunctionScope(_this._scope);
                    }
                }
                else {
                    if (node.kind === ts.SyntaxKind.CatchClause)
                        _this._handleBindingName(node.variableDeclaration.name, true, true);
                    _this._scope = new BlockScope(_this._scope.getFunctionScope(), _this._scope);
                }
                ts.forEachChild(node, cb);
                _this._scope.end(variableCallback);
                _this._scope = savedScope;
                return;
            }
            if (node.kind === ts.SyntaxKind.VariableDeclarationList) {
                _this._handleVariableDeclaration(node);
            }
            else if (node_1.isParameterDeclaration(node)) {
                var parent = node.parent;
                if (util_1.isFunctionWithBody(parent) &&
                    (node.name.kind !== ts.SyntaxKind.Identifier || node.name.originalKeywordKind !== ts.SyntaxKind.ThisKeyword)) {
                    _this._handleBindingName(node.name, false, util_1.isParameterProperty(node));
                    ts.forEachChild(node, cb);
                    return _this._scope.settle();
                }
            }
            else if (node_1.isEnumMember(node)) {
                _this._scope.addVariable(util_1.getPropertyName(node.name), node.name, false, true, 4);
            }
            else if (node_1.isImportClause(node) || node_1.isImportSpecifier(node) || node_1.isNamespaceImport(node) || node_1.isImportEqualsDeclaration(node)) {
                _this._handleDeclaration(node, false, 7);
            }
            else if (node_1.isTypeParameterDeclaration(node)) {
                _this._scope.addVariable(node.name.text, node.name, false, false, 2);
            }
            else if (node_1.isExportSpecifier(node)) {
                return _this._scope.markExported(node.propertyName || node.name);
            }
            else if (node_1.isExportAssignment(node)) {
                if (node_1.isIdentifier(node.expression))
                    return _this._scope.markExported(node.expression);
            }
            else if (node_1.isIdentifier(node)) {
                var domain = getUsageDomain(node);
                if (domain !== undefined)
                    _this._scope.addUse({ domain: domain, location: node });
                return;
            }
            return ts.forEachChild(node, cb);
        };
        ts.forEachChild(sourceFile, cb);
        this._scope.end(variableCallback);
        return this._result;
    };
    UsageWalker.prototype._handleNamespace = function (node) {
        this._scope.addVariable(node.name.text, node.name, false, isNamespaceExported(node), 1);
    };
    UsageWalker.prototype._handleDeclaration = function (node, blockScoped, domain) {
        if (node.name !== undefined)
            this._scope.addVariable(node.name.text, node.name, blockScoped, util_1.hasModifier(node.modifiers, ts.SyntaxKind.ExportKeyword), domain);
    };
    UsageWalker.prototype._handleBindingName = function (name, blockScoped, exported) {
        var _this = this;
        if (name.kind === ts.SyntaxKind.Identifier) {
            this._scope.addVariable(name.text, name, blockScoped, exported, 4);
        }
        else {
            util_1.forEachDestructuringIdentifier(name, function (declaration) {
                _this._scope.addVariable(declaration.name.text, declaration.name, blockScoped, exported, 4);
            });
        }
    };
    UsageWalker.prototype._handleVariableDeclaration = function (declarationList) {
        var blockScoped = util_1.isBlockScopedVariableDeclarationList(declarationList);
        var exported = declarationList.parent.kind === ts.SyntaxKind.VariableStatement &&
            util_1.hasModifier(declarationList.parent.modifiers, ts.SyntaxKind.ExportKeyword);
        for (var _i = 0, _a = declarationList.declarations; _i < _a.length; _i++) {
            var declaration = _a[_i];
            this._handleBindingName(declaration.name, blockScoped, exported);
        }
    };
    return UsageWalker;
}());
function isNamespaceExported(node) {
    return node.parent.kind === ts.SyntaxKind.ModuleDeclaration || util_1.hasModifier(node.modifiers, ts.SyntaxKind.ExportKeyword);
}
//# sourceMappingURL=data:application/json;base64,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