"use strict";
var setup_1 = require('./setup');
/** Class for mocking objects/interfaces in Typescript */
var Mock = (function () {
    function Mock(obj) {
        if (obj === void 0) { obj = {}; }
        this._object = {};
        this.originalPropertyValues = [];
        this._object = obj;
    }
    /** Create mock from a Type */
    Mock.of = function (type) {
        return new Mock(new type());
    };
    Object.defineProperty(Mock.prototype, "Object", {
        /** Return the mocked object */
        get: function () {
            return this._object;
        },
        enumerable: true,
        configurable: true
    });
    Mock.prototype.setup = function (value) {
        var propertyName = value.toString().match(/return\s[\w\d_]*\.([\w\d$_]*)\;/)[1];
        return new setup_1.Setup(this._object, propertyName);
    };
    return Mock;
}());
exports.Mock = Mock;
