# http-swagger

Default net/http wrapper to automatically generate RESTful API documentation with Swagger 2.0.

[![Travis branch](https://img.shields.io/travis/swaggo/http-swagger/master.svg)](https://travis-ci.org/swaggo/http-swagger)
[![Codecov branch](https://img.shields.io/codecov/c/github/swaggo/http-swagger/master.svg)](https://codecov.io/gh/swaggo/http-swagger)
[![Go Report Card](https://goreportcard.com/badge/github.com/swaggo/http-swagger)](https://goreportcard.com/report/github.com/swaggo/http-swagger)
[![GoDoc](https://godoc.org/github.com/swaggo/http-swagger?status.svg)](https://godoc.org/github.com/swaggo/http-swagger)

## Usage

### Start using it
1. Add comments to your API source code, [See Declarative Comments Format](https://github.com/swaggo/swag#declarative-comments-format).
2. Download [Swag](https://github.com/swaggo/swag) for Go by using:

```sh
$ go get github.com/swaggo/swag/cmd/swag
```

3. Run the [Swag](https://github.com/swaggo/swag) in your Go project root folder which contains `main.go` file, [Swag](https://github.com/swaggo/swag) will parse comments and generate required files(`docs` folder and `docs/doc.go`).
```sh
$ swag init
```
4.Download [http-swagger](https://github.com/swaggo/http-swagger) by using:
```sh
$ go get -u github.com/swaggo/http-swagger
```
And import following in your code:

```go
import "github.com/swaggo/http-swagger" // http-swagger middleware
```

### Canonical example:

```go
package main

import (
	"net/http"

	"github.com/go-chi/chi"
	"github.com/swaggo/http-swagger"
	_ "github.com/swaggo/http-swagger/example/go-chi/docs" // docs is generated by Swag CLI, you have to import it.
)

// @title Swagger Example API
// @version 1.0
// @description This is a sample server Petstore server.
// @termsOfService http://swagger.io/terms/

// @contact.name API Support
// @contact.url http://www.swagger.io/support
// @contact.email support@swagger.io

// @license.name Apache 2.0
// @license.url http://www.apache.org/licenses/LICENSE-2.0.html

// @host petstore.swagger.io
// @BasePath /v2
func main() {
	r := chi.NewRouter()

	r.Get("/swagger/*", httpSwagger.Handler(
		httpSwagger.URL("http://localhost:1323/swagger/doc.json"), //The url pointing to API definition"
	))

	http.ListenAndServe(":1323", r)
}

```

5. Run it, and browser to http://localhost:1323/swagger/index.html, you can see Swagger 2.0 Api documents.

![swagger_index.html](https://user-images.githubusercontent.com/8943871/36250587-40834072-1279-11e8-8bb7-02a2e2fdd7a7.png)

